#include "MArbitro.h"
 
namespace MArbitro
{ 

    void pintaArbitro(TArbitro a)
    {  
      cout << "Colegiado Numero: " << a.num_colegiado << endl;
      cout << "Nombre          :"  << a.nombre << " "
                                   << a.ape1 << " "
                                   << a.ape2 << endl;
      cout << "Zona            : " << zona_a_cadena(a.zona) << endl;
      
    }
    
    string zona_a_cadena(TZona zona)
    {
       string res;
           
       switch(zona)
       {
         case norte: res="norte"; break;
         case sur  : res="sur";   break;
         case este : res="este";  break;
         case oeste: res="oeste"; break;
       }
       return res;   
    }
    
    void cadena_a_zona(string s, TZona &zona, bool &ok)
    {
      
      zona = norte;
      ok = false;
      
      while( (zona<=oeste) && (!ok) )
      {     
        if (zona_a_cadena(zona)==s)
        {
          ok = true;
        }
        else
        {
          zona = SUC(zona);
        }
      }
    }
    
    TZona SUC(TZona zona)
    {
      TNatural ordinal;
      TZona sucesor;
      
      ordinal = TNatural(zona);
      sucesor = TZona(ordinal+1);
      
      return sucesor;
    
    }
    
    TArbitro LeeArbitro(TNatural num)
    {
      TArbitro a; 
      
      a.num_colegiado = num;
      cout << "Nombre          : ";
      getline(cin,a.nombre,ENTER);
      cout << "Apellido 1      : ";
      getline(cin,a.ape1,ENTER);
      cout << "Apellido 2      : ";
      getline(cin,a.ape2,ENTER);
      cout << "Zona            : ";
      a.zona = LeeZona();
       
      return a;
    }
    
    TZona LeeZona()
    {
      string sZona;
      bool ok;
      TZona zona;
    
      getline(cin,sZona,ENTER);
    
      cadena_a_zona(sZona,zona,ok);
      while (!ok)
      {
        cout << "Zona Errnea ... " 
             << "Elija entre: norte, sur, este, oeste."
             << endl;
        cout << "Zona            : ";
        getline(cin,sZona,ENTER);
        cadena_a_zona(sZona,zona,ok);
      }
    
      return zona;
    }
    
    void LeeArbitroFichero(ifstream &in, TArbitro &a)
    {
      string sZona;
      bool ok;
        
      in >> a.num_colegiado;
      in.ignore();
      getline(in,a.nombre,SEPARADOR);
      getline(in,a.ape1,SEPARADOR);
      getline(in,a.ape2,SEPARADOR);
      getline(in,sZona,ENTER);
      cadena_a_zona(sZona,a.zona,ok);
    }
    
    void EscribeArbitroFichero(ofstream &out, TArbitro a)
    {  
      out << a.num_colegiado << ESPACIO
          << a.nombre        << SEPARADOR
          << a.ape1          << SEPARADOR
          << a.ape2          << SEPARADOR
          << zona_a_cadena(a.zona) << endl;
    }

}
