#ifndef _MARBITRO_H_
#define _MARBITRO_H_

#include <iostream>
#include <cstdlib>
#include <fstream>
#include <string>

using namespace std;

namespace MArbitro
{ 
  const char ENTER = '\n';
  const char ESPACIO = ' ';
  const char SEPARADOR = '#';
  
  typedef unsigned int TNatural;
  typedef enum { norte, sur, este, oeste } TZona;
  
  struct TArbitro
  { 
    TNatural num_colegiado;
    string nombre;
    string ape1;
    string ape2;
    TZona zona;             
  };

  void pintaArbitro(TArbitro a);
  string zona_a_cadena(TZona zona);
  void cadena_a_zona(string s, TZona &zona, bool &ok);
  TZona SUC(TZona zona);
  TArbitro LeeArbitro(TNatural num);
  TZona LeeZona();
  void LeeArbitroFichero(ifstream &in, TArbitro &a);
  void EscribeArbitroFichero(ofstream &out, TArbitro a);
  
}
#endif
