#include "MLista.h"

namespace MLista
{ 
  TListaArbitros CrearListaArbitros()
  {
    return NULL;
  }
  
  void DestruirListaArbitros(TListaArbitros &l)
  {
    TListaArbitros ptr;
    
    while(l!=NULL)
    {
      ptr = l;
      l = l->sig;
      delete(ptr);
    }
    
  }
  
  void InsertarArbitro(TListaArbitros &l, TArbitro a, bool &llena)
  {
    TListaArbitros nuevoNodo;
    
    llena = ListaArbitrosLlena(l);
    
    if (!llena)
    {
      if ( (l==NULL) || 
           (a.num_colegiado < l->arbitro.num_colegiado) )
      { // Inserto por la cabeza
        nuevoNodo = new (TNodo);
        nuevoNodo->arbitro = a;
        nuevoNodo->sig = l;
        l = nuevoNodo;
      }
      else if (a.num_colegiado > l->arbitro.num_colegiado)
      { // Insero en el resto de la lista
        InsertarArbitro(l->sig,a,llena);
      }
      // Notese que se ignora el igual
    }
  }
 
  bool ListaArbitrosLlena(TListaArbitros l)
  { 
    TListaArbitros aux;
    bool llena;
    
    aux = new (TNodo);
    llena = (aux==NULL);
    /* estar llena si no puedo reservar memoria 
       para un nuevo nodo. Y en ese caso, la funcin 
       new retorna un NULL
    */
    
    if (!llena)
    {
      delete(aux);
      // borro aux porque slo lo uso para ver si se puede.
    }
    
    return llena;
  }
  
  bool ListaArbitrosVacia(TListaArbitros l)
  {
    return (l==NULL);
  }
  
  void BorrarArbitro(TListaArbitros &l, TNatural numero)
  {
    TListaArbitros ptr;
    
    if ( (l!=NULL) && 
         (numero >= l->arbitro.num_colegiado) )
    {
       if (numero == l->arbitro.num_colegiado)
       {
         ptr = l;
         l = l->sig;
         delete(ptr);
       }
       else
       {
         BorrarArbitro(l->sig,numero);
       }
    }

  }
  
  void SacarMasAntiguo(TListaArbitros &l, TArbitro &a, bool &vacia)
  {
    TListaArbitros ptr;
    
    vacia = ListaArbitrosVacia(l);
    
    if (!vacia)
    { 
      a = l->arbitro;
      ptr = l;
      l = l->sig;
      delete(ptr);
    }
  }
  
  void InsertaArbitrosFichero(TListaArbitros &l,string nomFich)
  { 
    ifstream in;
    TArbitro a;
    bool llena;
  
    in.open(nomFich.c_str());
  
    if (!in.bad())
    {  
      LeeArbitroFichero(in,a);
      while (!in.eof())
      {
        InsertarArbitro(l,a,llena);
        LeeArbitroFichero(in,a);
      }
      in.close();
    }  
  }

  void SalvaArbitrosFichero(TListaArbitros l,string nomFich)
  { 
    ofstream out;
    TListaArbitros ptr;
    out.open(nomFich.c_str());
  
    ptr = l;
    while(ptr!=NULL)
    {    
      EscribeArbitroFichero(out,ptr->arbitro);
      ptr=ptr->sig;
    }

    out.close();
  
  }

}

