#include <iostream>
#include <cstdlib>
#include <fstream>
#include <string>

#include "MLista.h"

using namespace std;
using namespace MLista;

//TIPOS

char menu();
bool confirmar();
void duplicaLista(TListaArbitros &origen, TListaArbitros &destino);
void buscarArbitro(TListaArbitros &l, TNatural num, 
                   TArbitro &a, bool &encontrado);

void listado_arbitros(TListaArbitros &l);
void asignaArbitro(TListaArbitros &l, TZona z1, TZona z2, TArbitro &a);

int main()
{ bool salir,encontrado,llena,vacia,ok;
  char op;
  TArbitro a;
  TNatural num;
  TListaArbitros lista_arbitros;
  string nomFich,eq1,eq2;
  TZona zona1,zona2;

  salir = false;
  lista_arbitros = CrearListaArbitros();
  
  while(!salir)
  { op = menu();
  
    switch(op)
    { case 'A': cout << "Colegiado Numero: " ;
                cin >> num;
                cin.ignore(); // Ignoro el ENTER                  
                buscarArbitro(lista_arbitros,num,a,encontrado);
                
                if (encontrado)
                {
                  cout << "El Colegiado ya existe ... " << endl;
                  pintaArbitro(a);
                }
                else
                {
                  a = LeeArbitro(num);
                  InsertarArbitro(lista_arbitros,a,llena);
                }
                break;
      case 'B': cout << "Nombre del Ficher de Texto: ";
                getline(cin,nomFich,ENTER);
                InsertaArbitrosFichero(lista_arbitros,nomFich);
                break;
      case 'C': cout << "Colegiado Numero: " ;
                cin >> num;
                cin.ignore(); // Ignoro el ENTER  
                buscarArbitro(lista_arbitros,num,a,encontrado);
                
                if (encontrado)
                {
                  cout << "El siguiente rbitro va a ser borrado .." 
                       << endl;
                  pintaArbitro(a);
                  ok = confirmar();
                  
                  if (ok)
                  {
                    BorrarArbitro(lista_arbitros,num);
                  }
                }
                else
                {
                  cout << "El Colegiado NO existe ... " << endl;
                }
                break;      
      case 'D': cout << "Nombre del Ficher de Texto: ";
                getline(cin,nomFich,ENTER);
                SalvaArbitrosFichero(lista_arbitros,nomFich);
                break;      
      case 'E': listado_arbitros(lista_arbitros);
                break;
      case 'F': cout << "Equipo 1: ";
                getline(cin,eq1,ENTER);
                cout << "Zona    :";
                zona1 = LeeZona();
                cout << "Equipo 2 ";
                getline(cin,eq2,ENTER);
                cout << "Zona    :";
                zona2 = LeeZona();
                asignaArbitro(lista_arbitros,zona1,zona2,a);
                cout << "Arbitro Asignado: " << endl;
                pintaArbitro(a);                
                break;      
      case 'X': salir = confirmar();
                break;                
    }
    
    if (op!='X')
    { 
      system("PAUSE");
      system("CLS");
    }
  }
  
  DestruirListaArbitros(lista_arbitros);
  return 0;
}

char menu()
{ char op;

  cout << "Nombre: (Apellidos, Nombre)            Curso: 1" << endl;
  cout << "Especialidad: (Gestin/Sistemas" << endl;
  cout << "Puesto: nmero de ordenador            Fecha: 20/06/2012" << endl;
  cout << endl;
  cout << "ARBITROS EUROCOPA" << endl;
  cout << "=================" << endl;  
  cout << "A. Insertar Arbitro desde Teclado." << endl;
  cout << "B. Insertar Arbitros desde Fichero." << endl;
  cout << "C. Borrar Arbitro." << endl;
  cout << "D. Salvar Arbitros a Fichero." << endl;
  cout << "E. Listar Arbitros." << endl;
  cout << "F. Asignar Arbitro a Partido." << endl;
  cout << endl;
  cout << "X. Salir del Programa" << endl;
  cout << endl;
  cout << "Introduzca Opcin:";
  
  cin >> op;
  cin.ignore(); // Ignoro el ENTER
  op = toupper(op);
  while( ((op<'A') || (op>'F')) && (op!='X') )
  { cout << "... Opcin Incorrecta ..." << endl;
    cout << endl;
    cout << "Introduzca Opcin:";
    cin >> op;
    cin.ignore(); // Ignoro el ENTER
    op = toupper(op);
  }
  return op;
}

bool confirmar()
{ char car;

  cout << "Est seguro (S/N)?";
  cin >> car;
  cin.ignore(); // Ignoro el ENTER  
  car = toupper(car);

  return (car=='S');
}

                         
void duplicaLista(TListaArbitros &origen, TListaArbitros &destino)
{ 
  TListaArbitros aux;
  TArbitro a;
  bool vacia, llena;
  
  aux = CrearListaArbitros();
  destino = CrearListaArbitros();
  
  while(!ListaArbitrosVacia(origen))
  {
    SacarMasAntiguo(origen,a,vacia);
    InsertarArbitro(aux, a, llena);
  }
  
  while(!ListaArbitrosVacia(aux))
  {
    SacarMasAntiguo(aux,a,vacia);
    InsertarArbitro(origen, a, llena);
    InsertarArbitro(destino, a, llena);    
  }
  
  DestruirListaArbitros(aux);
}

void buscarArbitro(TListaArbitros &l, TNatural num, 
                   TArbitro &a, bool &encontrado)
{
  TListaArbitros aux;
  bool vacia;

  duplicaLista(l,aux);
  encontrado = false;
  
  while ( (!encontrado) && (!ListaArbitrosVacia(aux) ) )
  {
    SacarMasAntiguo(aux,a,vacia);
    encontrado = (a.num_colegiado == num);
  }
  
  DestruirListaArbitros(aux);
}

void listado_arbitros(TListaArbitros &l)
{
  TArbitro a;
  bool vacia;
  TListaArbitros copia;

  duplicaLista(l,copia);
  
  while(!ListaArbitrosVacia(copia))
  {
    SacarMasAntiguo(copia,a,vacia);
    pintaArbitro(a);
  }
  DestruirListaArbitros(copia);
 
}

void asignaArbitro(TListaArbitros &l, TZona z1, TZona z2, TArbitro &a)
{
  bool vacia,ok;
  TListaArbitros copia;

  duplicaLista(l,copia);
  ok = false;
  
  while(!ListaArbitrosVacia(copia) && (!ok))
  {
    SacarMasAntiguo(copia,a,vacia);
    ok = (a.zona!=z1) && (a.zona!=z2);

  }
  DestruirListaArbitros(copia);
  BorrarArbitro(l,a.num_colegiado);
}

