MODULE Arbitros;
FROM IO IMPORT WrStr,WrCard,RdStr,RdCard,WrLn,RdLn,RdKey,WrChar;
IMPORT FIO;
FROM Window IMPORT Clear;
FROM MCadena IMPORT TCadena,CopiaCadena,IgualCadena;
FROM MLista IMPORT TZona, TArbitro, TListaArbitros, CrearListaArbitros,
                   DestruirListaArbitros, InsertarArbitro, ListaArbitrosLlena,
                   ListaArbitrosVacia, BorrarArbitro, SacarMasAntiguo;

CONST
   ESPACIO   = ' ';

PROCEDURE Pausa();
VAR
 x:CHAR;
BEGIN
    WrLn;
    WrStr("Pulse Para Continuar ...");
    x:=RdKey();
END Pausa;

PROCEDURE menu():CHAR;
VAR
  op:CHAR;
BEGIN
  WrStr("Nombre: (Apellidos, Nombre)            Curso: 1");
  WrLn;
  WrStr("Especialidad: (Gestin)                Grupo: A");
  WrLn;
  WrStr("Puesto: nmero de ordenador            Fecha: 26/06/2003");
  WrLn;
  WrLn;
  WrStr("ARBITROS LFP");
  WrLn;
  WrStr("============");
  WrLn;
  WrStr("A. Insertar rbitro desde Teclado.");
  WrLn;
  WrStr("B. Insertar rbitros desde Fichero.");
  WrLn;
  WrStr("C. Borrar rbitro.");
  WrLn;
  WrStr("D. Listar rbitros.");
  WrLn;
  WrStr("E. Salvar rbitros a Fichero.");
  WrLn;
  WrStr("F. Asignar rbitro a Partido.");
  WrLn;
  WrLn;
  WrStr("X. Salir del Programa");
  WrLn;
  WrLn;
  WrStr("Introduzca Opcin:");
  op:=CAP(RdKey());
  WrChar(op);
  WrLn;
  RdLn;

  WHILE ( ((op<'A') OR (op>'F')) AND (op<>'X') ) DO
    WrStr("... Opcin Incorrecta ...");
    WrLn;
    WrLn;
    WrStr("Introduzca Opcin:");
    op:=CAP(RdKey());
    WrChar(op);
    WrLn;
    RdLn;
  END;
  RETURN op;
END menu;

PROCEDURE confirmar():BOOLEAN;
VAR
  car:CHAR;
BEGIN
  WrStr("Est seguro (S/N)?");
  car:=CAP(RdKey());
  RdLn;
  RETURN (car='S');
END confirmar;

PROCEDURE duplicaLista(VAR origen,destino:TListaArbitros);
VAR
  aux:TListaArbitros;
  a:TArbitro;
  vacia, llena:BOOLEAN;
BEGIN
  aux:= CrearListaArbitros();
  destino:= CrearListaArbitros();

  WHILE(NOT ListaArbitrosVacia(origen)) DO
    SacarMasAntiguo(origen,a,vacia);
    InsertarArbitro(aux, a, llena);
  END;

  WHILE (NOT ListaArbitrosVacia(aux)) DO
    SacarMasAntiguo(aux,a,vacia);
    InsertarArbitro(origen, a, llena);
    InsertarArbitro(destino, a, llena);
  END;

  DestruirListaArbitros(aux);
END duplicaLista;

PROCEDURE buscarArbitro(VAR l:TListaArbitros; num:CARDINAL;
                        VAR a:TArbitro; VAR encontrado:BOOLEAN);
VAR
  aux:TListaArbitros;
  vacia:BOOLEAN;
BEGIN
  duplicaLista(l,aux);
  encontrado:= FALSE;

  WHILE ( (NOT encontrado) AND ( NOT ListaArbitrosVacia(aux) ) ) DO
    SacarMasAntiguo(aux,a,vacia);
    encontrado:= (a.num_colegiado = num);
  END;

  DestruirListaArbitros(aux);
END buscarArbitro;

PROCEDURE zona_a_cadena(zona:TZona; VAR s:TCadena);
BEGIN
   CASE zona OF
     norte: CopiaCadena("norte",s); |
     sur  : CopiaCadena("sur",s);   |
     este : CopiaCadena("este",s);  |
     oeste: CopiaCadena("oeste",s); |
   END;
END zona_a_cadena;

PROCEDURE cadena_a_zona(s:TCadena; VAR zona:TZona; VAR ok:BOOLEAN);
VAR
  sZona:TCadena;
BEGIN
  zona:= norte;
  ok:= FALSE;

  WHILE( (zona<oeste) AND (NOT ok) ) DO
    zona_a_cadena(zona,sZona);
    IF (IgualCadena(s,sZona)) THEN
      ok:=TRUE;
    ELSE
      INC(zona);
    END;
  END;

  IF (NOT ok) THEN
     zona:=oeste;
     ok:=IgualCadena(s,sZona)
  END;
END cadena_a_zona;

PROCEDURE LeeZona():TZona;
VAR
  sZona:TCadena;
  ok:BOOLEAN;
  zona:TZona;
BEGIN

  RdStr(sZona);
  cadena_a_zona(sZona,zona,ok);
  WHILE ( NOT ok) DO
    WrStr("Zona Errnea ... ");
    WrStr("Elija entre: norte, sur, este, oeste.");
    WrLn;
    WrStr("Zona            : ");
    RdStr(sZona);
    cadena_a_zona(sZona,zona,ok);
  END;

  RETURN zona;
END LeeZona;


PROCEDURE LeeArbitro(num:CARDINAL):TArbitro;
VAR
  a:TArbitro;
BEGIN
  a.num_colegiado := num;
  WrStr("Nombre          : ");
  RdStr(a.nombre);
  WrStr("Apellido 1      : ");
  RdStr(a.ape1);
  WrStr("Apellido 2      : ");
  RdStr(a.ape2);
  WrStr("Zona            : ");
  a.zona := LeeZona();

  RETURN a;
END LeeArbitro;


PROCEDURE pintaArbitro(a:TArbitro);
VAR
  sZona:TCadena ;
BEGIN
  zona_a_cadena(a.zona,sZona);
  WrStr("Colegiado Numero: ");
  WrCard(a.num_colegiado,0);
  WrLn;
  WrStr("Nombre          :");
  WrStr(a.nombre);
  WrStr(" ");
  WrStr(a.ape1);
  WrStr(" ");
  WrStr(a.ape2);
  WrLn;
  WrStr("Zona            : ");
  WrStr(sZona);
  WrLn;
END pintaArbitro;

PROCEDURE LeeArbitroFichero(VAR fich:FIO.File; VAR a:TArbitro);
VAR
  sZona:TCadena;
  ok:BOOLEAN;
BEGIN
  a.num_colegiado:=FIO.RdCard(fich);
  FIO.RdStr(fich, a.nombre);
  FIO.RdStr(fich, a.ape1);
  FIO.RdStr(fich, a.ape2);
  FIO.RdStr(fich, sZona);
  cadena_a_zona(sZona,a.zona,ok);

END LeeArbitroFichero;

PROCEDURE InsertaArbitrosFichero(VAR l:TListaArbitros;nomFich:TCadena);
VAR
  fich:FIO.File;
  a:TArbitro;
  llena:BOOLEAN;

BEGIN

  IF (FIO.Exists(nomFich)) THEN
     fich :=FIO.OpenRead(nomFich);

     LeeArbitroFichero(fich,a);
     WHILE (NOT FIO.EOF) DO
       InsertarArbitro(l,a,llena);
       LeeArbitroFichero(fich,a);
     END;
     FIO.Close(fich);
  END;

END InsertaArbitrosFichero;

PROCEDURE EscribeArbitroFichero(VAR out:FIO.File; a:TArbitro);
VAR
  sZona:TCadena;
BEGIN
  zona_a_cadena(a.zona,sZona);
  FIO.WrCard(out,a.num_colegiado,0);
  FIO.WrChar(out,ESPACIO);
  FIO.WrStr(out,a.nombre);
  FIO.WrLn(out);
  FIO.WrStr(out,a.ape1);
  FIO.WrLn(out);
  FIO.WrStr(out,a.ape2);
  FIO.WrLn(out);
  FIO.WrStr(out,sZona);
  FIO.WrLn(out);
END EscribeArbitroFichero;

PROCEDURE SalvaArbitrosFichero(VAR l:TListaArbitros; nomFich:TCadena);
VAR
  out:FIO.File;
  a:TArbitro;
  vacia:BOOLEAN;
  copia:TListaArbitros;
BEGIN
  duplicaLista(l,copia);
  out := FIO.Create(nomFich);

  WHILE (NOT ListaArbitrosVacia(copia)) DO
    SacarMasAntiguo(copia,a,vacia);
    EscribeArbitroFichero(out,a);
  END;

  DestruirListaArbitros(copia);
  FIO.Close(out);

END SalvaArbitrosFichero;


PROCEDURE listado_arbitros(VAR l:TListaArbitros);
VAR
  a:TArbitro;
  vacia:BOOLEAN;
  copia:TListaArbitros;
BEGIN
  duplicaLista(l,copia);

  WHILE ( NOT ListaArbitrosVacia(copia)) DO
    SacarMasAntiguo(copia,a,vacia);
    pintaArbitro(a);
  END;

  DestruirListaArbitros(copia);

END listado_arbitros;

PROCEDURE asignaArbitro(VAR l:TListaArbitros; z1, z2:TZona;
                        VAR a:TArbitro);
VAR
  vacia,ok:BOOLEAN;
  copia:TListaArbitros;
BEGIN

  duplicaLista(l,copia);
  ok:= FALSE;

  WHILE ( NOT ListaArbitrosVacia(copia) AND (NOT ok)) DO
    SacarMasAntiguo(copia,a,vacia);
    ok:= (a.zona<>z1) AND (a.zona<>z2);
  END;

  DestruirListaArbitros(copia);
  BorrarArbitro(l,a.num_colegiado);

END asignaArbitro;

VAR (* Variables del P.P. *)

  salir,encontrado,llena,vacia,ok:BOOLEAN;
  op:CHAR;
  a:TArbitro;
  num:CARDINAL;
  lista_arbitros:TListaArbitros ;
  nomFich,eq1,eq2:TCadena ;
  zona1,zona2:TZona ;

BEGIN

  salir:= FALSE;
  lista_arbitros:= CrearListaArbitros();

  WHILE (NOT salir) DO
    op:= menu();

    CASE op OF
       'A': WrStr("Colegiado Numero: ");
            num:=RdCard();
            buscarArbitro(lista_arbitros,num,a,encontrado);

            IF (encontrado) THEN
                WrStr("El Colegiado ya existe ... ");
                WrLn;
                pintaArbitro(a);
            ELSE
                a:= LeeArbitro(num);
                InsertarArbitro(lista_arbitros,a,llena);
            END;
            |
       'B': WrStr("Nombre del Ficher de Texto: ");
            RdStr(nomFich);
            InsertaArbitrosFichero(lista_arbitros,nomFich);
            |
       'C': WrStr("Colegiado Numero: ");
            num:=RdCard();
            buscarArbitro(lista_arbitros,num,a,encontrado);

            IF (encontrado) THEN
               WrStr("El siguiente rbitro va a ser borrado ..");
               WrLn;
               pintaArbitro(a);
               ok:= confirmar();

               IF (ok) THEN
                   BorrarArbitro(lista_arbitros,num);
               END;
            ELSE
               WrStr("El Colegiado NO existe ... ");
               WrLn;
            END;
            |
       'D': listado_arbitros(lista_arbitros);
            |
       'E': WrStr("Nombre del Ficher de Texto: ");
            RdStr(nomFich);
            SalvaArbitrosFichero(lista_arbitros,nomFich);
            |
       'F': WrStr("Equipo 1: ");
            RdStr(eq1);
            WrStr("Zona    :");
            zona1:= LeeZona();
            WrStr("Equipo 2 ");
            RdStr(eq2);
            WrStr("Zona    :");
            zona2:= LeeZona();
            asignaArbitro(lista_arbitros,zona1,zona2,a);
            WrStr("Arbitro Asignado: ");
            WrLn;
            pintaArbitro(a);
            |
       'X': salir:= confirmar();
            |
    END;

    IF (op<>'X') THEN
      Pausa();
      Clear();
    END;

  END;

  DestruirListaArbitros(lista_arbitros);

END Arbitros.