IMPLEMENTATION MODULE MLista;
FROM Storage IMPORT ALLOCATE,DEALLOCATE,Available;
FROM MCadena IMPORT TCadena,CopiaCadena,IgualCadena;


TYPE
  TNodo = RECORD
    arbitro:TArbitro ;
    sig:TListaArbitros ;
  END;

  TListaArbitros = POINTER TO TNodo;

  PROCEDURE CrearListaArbitros():TListaArbitros;
  BEGIN
    RETURN NIL;
  END CrearListaArbitros;


  PROCEDURE DestruirListaArbitros(VAR l:TListaArbitros);
  VAR
    ptr:TListaArbitros;
  BEGIN

    WHILE (l<>NIL) DO
      ptr := l;
      l := l^.sig;
      DISPOSE(ptr);
    END;

  END DestruirListaArbitros;

  PROCEDURE InsertarArbitro(VAR l:TListaArbitros; a:TArbitro;
                            VAR llena:BOOLEAN);
  VAR
    nuevoNodo:TListaArbitros;
  BEGIN

    llena := ListaArbitrosLlena(l);

    IF (NOT llena) THEN
      IF ( (l=NIL) OR (a.num_colegiado < l^.arbitro.num_colegiado) ) THEN
        (* Inserto por la cabeza *)
         NEW(nuevoNodo);
         nuevoNodo^.arbitro:= a;
         nuevoNodo^.sig:= l;
         l:= nuevoNodo;
      ELSIF (a.num_colegiado > l^.arbitro.num_colegiado) THEN
        (* Insero en el resto de la lista *)
        InsertarArbitro(l^.sig,a,llena);
      END;
      (* Notese que se ignora el caso de igual *)
    END;
  END InsertarArbitro;

  PROCEDURE ListaArbitrosLlena(l:TListaArbitros):BOOLEAN;
  BEGIN
    RETURN NOT Available(SIZE(TNodo));
  END ListaArbitrosLlena;


  PROCEDURE ListaArbitrosVacia(l:TListaArbitros):BOOLEAN;
  BEGIN
    RETURN (l=NIL);
  END ListaArbitrosVacia;

  PROCEDURE BorrarArbitro(VAR l:TListaArbitros; numero:CARDINAL);
  VAR
    ptr:TListaArbitros;
  BEGIN
    IF ( (l<>NIL) AND (numero>=l^.arbitro.num_colegiado) ) THEN
       IF (numero = l^.arbitro.num_colegiado) THEN
         ptr:= l;
         l := l^.sig;
         DISPOSE(ptr);
       ELSE
         BorrarArbitro(l^.sig,numero);
      END;
    END;

  END BorrarArbitro;

  PROCEDURE SacarMasAntiguo(VAR l:TListaArbitros; VAR a:TArbitro;
                            VAR vacia:BOOLEAN);
  VAR
    ptr:TListaArbitros;
  BEGIN
    vacia:= ListaArbitrosVacia(l);

    IF (NOT vacia) THEN
      a:= l^.arbitro;
      ptr:= l;
      l:= l^.sig;
      DISPOSE(ptr);
    END;
  END SacarMasAntiguo;

END MLista.