#include <stdlib.h>
#include <iostream.h>
#include <ctype.h>
#include <fstream.h>
#include "Cola.h"
#include "Cadena.h"

using namespace MCadena;
using namespace MCola;

//CONSTANTES
const int NUM_BUSES = 5;
const char ESP = ' ';

//TIPOS
typedef TCola TParada[NUM_BUSES];


char menu();
bool confirmar_salida();

void inicializarParada(TParada &parada);
void destruirParada(TParada &parada);
void PintarParada(TParada parada);
void duplicaParada(TParada parada, TParada &copia);
void duplicaCola(TCola &parada, TCola &copia);
void BuscarPersonaParada(TParada parada, TCadena persona,
                         int &bus, bool &encontrada);
void salvarParadaTXT(TParada parada,  TCadena nomFich);
void cargarParadaTXT(TParada &parada, TCadena nomFich);
int leerBus();

int main()
{ bool salir,encontrada;
  char op;
  TParada parada;
  TCadena persona,nomFich;
  int bus,libres;
  
  inicializarParada(parada);
  salir = false;
  
  while(!salir)
  { op = menu();
  
    switch(op)
    { case 'A': cout << "Nombre de la Persona: ";
                cin >> persona;
                bus = leerBus();   
                
                if (ColaLlena(parada[bus]))
                { cout << "Error: Parada LLENA"
                       << endl;
                }
                else
                { MeterCola(parada[bus],persona);
                }
                break;
      case 'B': cout << "Plazas Libres: ";
                cin >> libres;
                bus = leerBus();
                while ( (!ColaVacia(parada[bus])) 
                        && (libres>0) )
                { SacarCola(parada[bus],persona);
                  --libres;
                  cout << persona << " entra en el Bus"
                       << endl;
                }              
                cout << "El bus se va con "
                     << libres << " plazas libres"
                     << endl;
                break;
      case 'C': cout << "Nombre de la Persona: ";
                cin >> persona;
                BuscarPersonaParada(parada,persona,
                                    bus,encontrada);
                if (encontrada)
                { cout << persona << " espera el bus "
                       << bus << endl;
                }
                else
                { cout << persona << " NO est en la parada"
                       << endl;
                }
                break;      
      case 'D': PintarParada(parada);
                break;
      case 'E': cout << "Nombre del Fichero: ";
                cin >> nomFich;
                salvarParadaTXT(parada,nomFich);
                break;      
      case 'F': cout << "Nombre del Fichero: ";
                cin >> nomFich;
                cargarParadaTXT(parada,nomFich);
                break;      
      case 'X': salir = confirmar_salida();
                break;                
    }
    
    if (op!='X')
    { 
      system("PAUSE");
      system("CLS");
    }
  }
  
  destruirParada(parada);
  return 0;
}

char menu()
{ char op;

  cout << "Nombre: (Apellidos, Nombre)            Curso:" << endl;
  cout << "Especialidad: (Gestin)                Grupo: A" << endl;
  cout << "Puesto: nmero de ordenador            Fecha: 04/07/2002" << endl;
  cout << endl;
  cout << "EXAMEN LP" << endl;
  cout << "A. Llegar Persona Parada" << endl;
  cout << "B. Llegar Bus Parada" << endl;
  cout << "C. Buscar Persona Parada" << endl;
  cout << "D. PintarParada" << endl;
  cout << "E. Salvar Parada Fichero" << endl;
  cout << "F. Cargar Parada Fichero" << endl;
  cout << endl;
  cout << "X. Salir del Programa" << endl;
  cout << endl;
  cout << "Introduzca Opcin:";
  
  cin >> op;
  op = toupper(op);
  while( ((op<'A') || (op>'F')) && (op!='X') )
  { cout << "... Opcin Incorrecta ..." << endl;
    cout << endl;
    cout << "Introduzca Opcin:";
    cin >> op;
    op = toupper(op);
  }
  return op;
}

bool confirmar_salida()
{ char car;

  cout << "Est seguro de salir (S/N)?";
  cin >> car;
  car = toupper(car);

  return (car=='S');
}

int leerBus()
{ int bus;

  cout << "Bus que desea tomar[1-" 
       << NUM_BUSES << "]: ";
  cin >> bus;
  while( (bus<1) || (bus>NUM_BUSES) )
  { cout << "Nmero incorrecto de bus ..." << endl;
    cout << "Bus que desea tomar[1-" << NUM_BUSES << "]: ";
    cin >> bus;
  }
  --bus; 
  return bus;
}

void inicializarParada(TParada &parada)
{ int i;

  for(i=0;i<NUM_BUSES;++i)
  { parada[i] = CrearCola();
  }
}

void destruirParada(TParada &parada)
{ int i;

  for(i=0;i<NUM_BUSES;++i)
  { DestruirCola(parada[i]);
  }
}

void duplicaParada(TParada parada, TParada &copia)
{ int i;

  inicializarParada(copia);
  for(i=0;i<NUM_BUSES;++i)
  { duplicaCola(parada[i],copia[i]);
  }

}

void BuscarPersonaParada(TParada parada, TCadena persona,
                         int &bus, bool &encontrada)
{ TParada copia;
  TCadena x;

  duplicaParada(parada,copia);
  
  bus=0;
  while( (bus<NUM_BUSES) && (!encontrada) )
  { if (ColaVacia(copia[bus]))
    { ++bus;
    }
    else
    { SacarCola(copia[bus],x);
      encontrada = IgualCadena(persona,x);
    }
  }
  ++bus;
  destruirParada(copia);
}

void PintarParada(TParada parada)
{ TParada copia;
  TCadena x;
  int bus,old_bus;

  duplicaParada(parada,copia);
  
  bus=0;
  old_bus = -1;
  
  
  while(bus<NUM_BUSES) 
  { if (old_bus!=bus)
    { cout << endl << "Bus N " << (bus+1) << ':' ;
      old_bus=bus;
    }
    
    if (ColaVacia(copia[bus]))
    { ++bus;
    }
    else
    { SacarCola(copia[bus],x);
      cout << x << ESP;
    }
  }
  destruirParada(copia);
}
                         
void salvarParadaTXT(TParada parada,  TCadena nomFich)
{ TParada copia;
  TCadena x;
  int bus,old_bus;
  ofstream out;
  
  out.open(nomFich);
  
  if (out.bad())
  { cout << "Error al abrir " << nomFich << endl;
  }
  else
  { duplicaParada(parada,copia);
    bus=0;
    old_bus = 0;
  
    out << (bus+1) << ESP;
    while(bus<NUM_BUSES) 
    { if (old_bus!=bus)
      { out << '.' << endl << (bus+1) << ESP ;
        old_bus=bus;
      }
      if (ColaVacia(copia[bus]))
      { ++bus;
      }
      else
      { SacarCola(copia[bus],x);
        out << x << ESP;
      }
    }
    destruirParada(copia);
    out << '.' << endl;
    out.close();
  }
}

void cargarParadaTXT(TParada &parada, TCadena nomFich)
{ TParada copia;
  TCadena x;
  int bus;
  ifstream in;
  
  in.open(nomFich);
  
  if (in.bad())
  { cout << "Error al abrir " << nomFich << endl;
  }
  else
  { in >> bus;
    --bus;
    while(!in.eof()) 
    { in >> x;
      while( (!in.eof()) && (!IgualCadena(x,".")) )
      { MeterCola(parada[bus],x);
        in >> x;
      }
      in >> bus;
      --bus;
    }
    in.close();
  }
}

void duplicaCola(TCola &parada, TCola &copia)
{ TCola aux;
  TCadena x;
  
  aux   = CrearCola();
  copia = CrearCola();
  
  while(!ColaVacia(parada))
  { SacarCola(parada,x);
    MeterCola(aux,x);
  }
  
  while(!ColaVacia(aux))
  { SacarCola(aux,x);
    MeterCola(parada,x); // Restauro la Parada
    MeterCola(copia,x);  // Copio los elementos
  }
      
  DestruirCola(aux);
}

                         
