#include <stdlib.h>
#include "MCadena.h"
#include "MLista.h"

namespace MLista
{ using namespace MCadena;


  TListaArbitros CrearListaArbitros()
  {
    return NULL;
  }
  
  void DestruirListaArbitros(TListaArbitros &l)
  {
    TListaArbitros ptr;
    
    while(l!=NULL)
    {
      ptr = l;
      l = l->sig;
      delete(ptr);
    }
    
  }
  
  void InsertarArbitro(TListaArbitros &l, TArbitro a, bool &llena)
  {
    TListaArbitros nuevoNodo;
    
    llena = ListaArbitrosLlena(l);
    
    if (!llena)
    {
      if ( (l==NULL) || 
           (a.num_colegiado < l->arbitro.num_colegiado) )
      { // Inserto por la cabeza
        nuevoNodo = new (TNodo);
        nuevoNodo->arbitro = a;
        nuevoNodo->sig = l;
        l = nuevoNodo;
      }
      else if (a.num_colegiado > l->arbitro.num_colegiado)
      { // Insero en el resto de la lista
        InsertarArbitro(l->sig,a,llena);
      }
      // Notese que se ignora el igual
    }
  }
 
  bool ListaArbitrosLlena(TListaArbitros l)
  { 
    TListaArbitros aux;
    bool llena;
    
    aux = new (TNodo);
    llena = (aux==NULL);
    /* estar llena si no puedo reservar memoria 
       para un nuevo nodo. Y en ese caso, la funcin 
       new retorna un NULL
    */
    
    if (!llena)
    {
      delete(aux);
      // borro aux porque slo lo uso para ver si se puede.
    }
    
    return llena;
  }
  
  bool ListaArbitrosVacia(TListaArbitros l)
  {
    return (l==NULL);
  }
  
  void BorrarArbitro(TListaArbitros &l, TNatural numero)
  {
    TListaArbitros ptr;
    
    if ( (l!=NULL) && 
         (numero >= l->arbitro.num_colegiado) )
    {
       if (numero == l->arbitro.num_colegiado)
       {
         ptr = l;
         l = l->sig;
         delete(ptr);
       }
       else
       {
         BorrarArbitro(l->sig,numero);
       }
    }

  }
  
  void SacarMasAntiguo(TListaArbitros &l, TArbitro &a, bool &vacia)
  {
    TListaArbitros ptr;
    
    vacia = ListaArbitrosVacia(l);
    
    if (!vacia)
    { 
      a = l->arbitro;
      ptr = l;
      l = l->sig;
      delete(ptr);
    }
  }
}

