#ifndef _MLISTA_h_
#define _MLISTA_h_

#include "MCadena.h"

namespace MLista
{ using namespace MCadena;

  typedef unsigned int TNatural;
  typedef enum { norte, sur, este, oeste } TZona;
  
  struct TArbitro
  { 
    TNatural num_colegiado;
    TCadena nombre;
    TCadena ape1;
    TCadena ape2;
    TZona zona;             
  };
  
  typedef struct TNodo *TListaArbitros;
  struct TNodo
  { TArbitro arbitro;
    TListaArbitros sig;
  };

  TListaArbitros CrearListaArbitros();
  void DestruirListaArbitros(TListaArbitros &l);
  void InsertarArbitro(TListaArbitros &l, TArbitro a, bool &llena);
  bool ListaArbitrosLlena(TListaArbitros l);
  bool ListaArbitrosVacia(TListaArbitros l);
  void BorrarArbitro(TListaArbitros &l, TNatural numero);
  void SacarMasAntiguo(TListaArbitros &l, TArbitro &a, bool &vacia);
}

#endif
