#include <stdlib.h>
#include <iostream.h>
#include <ctype.h>
#include <fstream.h>
#include "MLista.h"
#include "MCadena.h"

using namespace MCadena;
using namespace MLista;

//CONSTANTES
const char ESPACIO   = ' ';
//TIPOS

char menu();
bool confirmar();
void duplicaLista(TListaArbitros &origen, TListaArbitros &destino);
void buscarArbitro(TListaArbitros &l, TNatural num, 
                   TArbitro &a, bool &encontrado);
void pintaArbitro(TArbitro a);
void zona_a_cadena(TZona zona, TCadena &s);
void cadena_a_zona(TCadena s, TZona &zona, bool &ok);
TZona SUC(TZona zona);
TArbitro LeeArbitro(TNatural num);
TZona LeeZona();
void InsertaArbitrosFichero(TListaArbitros &l,TCadena nomFich);
void SalvaArbitrosFichero(TListaArbitros &l,TCadena nomFich);
void LeeArbitroFichero(ifstream &in, TArbitro &a);
void EscribeArbitroFichero(ofstream &out, TArbitro a);
void listado_arbitros(TListaArbitros &l);
void asignaArbitro(TListaArbitros &l, TZona z1, TZona z2, TArbitro &a);

int main()
{ bool salir,encontrado,llena,vacia,ok;
  char op;
  TArbitro a;
  TNatural num;
  TListaArbitros lista_arbitros;
  TCadena nomFich,eq1,eq2;
  TZona zona1,zona2;

  salir = false;
  lista_arbitros = CrearListaArbitros();
  
  while(!salir)
  { op = menu();
  
    switch(op)
    { case 'A': cout << "Colegiado Numero: " ;
                cin >> num;
                cin.ignore(); // Ignoro el ENTER                  
                buscarArbitro(lista_arbitros,num,a,encontrado);
                
                if (encontrado)
                {
                  cout << "El Colegiado ya existe ... " << endl;
                  pintaArbitro(a);
                }
                else
                {
                  a = LeeArbitro(num);
                  InsertarArbitro(lista_arbitros,a,llena);
                }
                break;
      case 'B': cout << "Nombre del Ficher de Texto: ";
                cin.getline(nomFich,MAXCAD,ENTER);
                InsertaArbitrosFichero(lista_arbitros,nomFich);
                break;
      case 'C': cout << "Colegiado Numero: " ;
                cin >> num;
                cin.ignore(); // Ignoro el ENTER  
                buscarArbitro(lista_arbitros,num,a,encontrado);
                
                if (encontrado)
                {
                  cout << "El siguiente rbitro va a ser borrado .." 
                       << endl;
                  pintaArbitro(a);
                  ok = confirmar();
                  
                  if (ok)
                  {
                    BorrarArbitro(lista_arbitros,num);
                  }
                }
                else
                {
                  cout << "El Colegiado NO existe ... " << endl;
                }
                break;      
      case 'D': listado_arbitros(lista_arbitros);
                break;
      case 'E': cout << "Nombre del Ficher de Texto: ";
                cin.getline(nomFich,MAXCAD,ENTER);
                SalvaArbitrosFichero(lista_arbitros,nomFich);
                break;      
      case 'F': cout << "Equipo 1: ";
                cin.getline(eq1,MAXCAD,ENTER);
                cout << "Zona    :";
                zona1 = LeeZona();
                cout << "Equipo 2 ";
                cin.getline(eq2,MAXCAD,ENTER);
                cout << "Zona    :";
                zona2 = LeeZona();
                asignaArbitro(lista_arbitros,zona1,zona2,a);
                cout << "Arbitro Asignado: " << endl;
                pintaArbitro(a);                
                break;      
      case 'X': salir = confirmar();
                break;                
    }
    
    if (op!='X')
    { 
      system("PAUSE");
      system("CLS");
    }
  }
  
  DestruirListaArbitros(lista_arbitros);
  return 0;
}

char menu()
{ char op;

  cout << "Nombre: (Apellidos, Nombre)            Curso: 1" << endl;
  cout << "Especialidad: (Gestin)                Grupo: A" << endl;
  cout << "Puesto: nmero de ordenador            Fecha: 26/06/2003" << endl;
  cout << endl;
  cout << "ARBITROS LFP" << endl;
  cout << "============" << endl;  
  cout << "A. Insertar rbitro desde Teclado." << endl;
  cout << "B. Insertar rbitros desde Fichero." << endl;
  cout << "C. Borrar rbitro." << endl;
  cout << "D. Listar rbitros." << endl;
  cout << "E. Salvar rbitros a Fichero." << endl;
  cout << "F. Asignar rbitro a Partido." << endl;
  cout << endl;
  cout << "X. Salir del Programa" << endl;
  cout << endl;
  cout << "Introduzca Opcin:";
  
  cin >> op;
  cin.ignore(); // Ignoro el ENTER
  op = toupper(op);
  while( ((op<'A') || (op>'F')) && (op!='X') )
  { cout << "... Opcin Incorrecta ..." << endl;
    cout << endl;
    cout << "Introduzca Opcin:";
    cin >> op;
    cin.ignore(); // Ignoro el ENTER
    op = toupper(op);
  }
  return op;
}

bool confirmar()
{ char car;

  cout << "Est seguro (S/N)?";
  cin >> car;
  cin.ignore(); // Ignoro el ENTER  
  car = toupper(car);

  return (car=='S');
}

                         
void duplicaLista(TListaArbitros &origen, TListaArbitros &destino)
{ 
  TListaArbitros aux;
  TArbitro a;
  bool vacia, llena;
  
  aux = CrearListaArbitros();
  destino = CrearListaArbitros();
  
  while(!ListaArbitrosVacia(origen))
  {
    SacarMasAntiguo(origen,a,vacia);
    InsertarArbitro(aux, a, llena);
  }
  
  while(!ListaArbitrosVacia(aux))
  {
    SacarMasAntiguo(aux,a,vacia);
    InsertarArbitro(origen, a, llena);
    InsertarArbitro(destino, a, llena);    
  }
  
  DestruirListaArbitros(aux);
}

void buscarArbitro(TListaArbitros &l, TNatural num, 
                   TArbitro &a, bool &encontrado)
{
  TListaArbitros aux;
  bool vacia;

  duplicaLista(l,aux);
  encontrado = false;
  
  while ( (!encontrado) && (!ListaArbitrosVacia(aux) ) )
  {
    SacarMasAntiguo(aux,a,vacia);
    encontrado = (a.num_colegiado == num);
  }
  
  DestruirListaArbitros(aux);
}

void pintaArbitro(TArbitro a)
{
  TCadena sZona;
  
  zona_a_cadena(a.zona,sZona);
  cout << "Colegiado Numero: " << a.num_colegiado << endl;
  cout << "Nombre          :"  << a.nombre << " "
                               << a.ape1 << " "
                               << a.ape2 << endl;
  cout << "Zona            : " << sZona << endl;
  
}

void zona_a_cadena(TZona zona, TCadena &s)
{
   switch(zona)
   {
     case norte: CopiaCadena("norte",s); break;
     case sur  : CopiaCadena("sur",s);   break;
     case este : CopiaCadena("este",s);  break;
     case oeste: CopiaCadena("oeste",s); break;
   }
   
}

void cadena_a_zona(TCadena s, TZona &zona, bool &ok)
{
  TCadena sZona;
  
  zona = norte;
  ok = false;
  
  while( (zona<=oeste) && (!ok) )
  { zona_a_cadena(zona,sZona); 
    if (IgualCadena(s,sZona))
    {
      ok = true;
    }
    else
    {
      zona = SUC(zona);
    }
  }
}

TZona SUC(TZona zona)
{
  int ordinal;
  TZona sucesor;
  
  ordinal = int(zona);
  sucesor = TZona(ordinal+1);
  
  return sucesor;

}

TArbitro LeeArbitro(TNatural num)
{
  TArbitro a; 
  
  a.num_colegiado = num;
  cout << "Nombre          : ";
  cin.getline(a.nombre,MAXCAD,ENTER);
  cout << "Apellido 1      : ";
  cin.getline(a.ape1,MAXCAD,ENTER);
  cout << "Apellido 2      : ";
  cin.getline(a.ape2,MAXCAD,ENTER);
  cout << "Zona            : ";
  a.zona = LeeZona();
   
  return a;
}

TZona LeeZona()
{
  TCadena sZona;
  bool ok;
  TZona zona;

  cin.getline(sZona,MAXCAD,ENTER);

  cadena_a_zona(sZona,zona,ok);
  while (!ok)
  {
    cout << "Zona Errnea ... " 
         << "Elija entre: norte, sur, este, oeste."
         << endl;
    cout << "Zona            : ";
    cin.getline(sZona,MAXCAD,ENTER);
    cadena_a_zona(sZona,zona,ok);
  }

  return zona;
}

void InsertaArbitrosFichero(TListaArbitros &l,TCadena nomFich)
{ 
  ifstream in;
  TArbitro a;
  bool llena;
  
  in.open(nomFich);
  
  if (!in.bad())
  {  
    LeeArbitroFichero(in,a);
    while (!in.eof())
    {
      InsertarArbitro(l,a,llena);
      LeeArbitroFichero(in,a);
    }
    in.close();
  }
  
}

void SalvaArbitrosFichero(TListaArbitros &l,TCadena nomFich)
{ 
  ofstream out;
  TArbitro a;
  bool vacia;
  TListaArbitros copia;

  duplicaLista(l,copia);
  out.open(nomFich);
  
  while(!ListaArbitrosVacia(copia))
  {
    SacarMasAntiguo(copia,a,vacia);
    EscribeArbitroFichero(out,a);
  }
  DestruirListaArbitros(copia);
  out.close();
  
}

void LeeArbitroFichero(ifstream &in, TArbitro &a)
{
  TCadena sZona;
  bool ok;
    
  in >> a.num_colegiado;
  in.getline(a.nombre,MAXCAD,ENTER);
  in.getline(a.ape1,MAXCAD,ENTER);
  in.getline(a.ape2,MAXCAD,ENTER);
  in.getline(sZona,MAXCAD,ENTER);
  cadena_a_zona(sZona,a.zona,ok);
}

void EscribeArbitroFichero(ofstream &out, TArbitro a)
{
  TCadena sZona;
  
  zona_a_cadena(a.zona,sZona);
  out << a.num_colegiado << ESPACIO
      << a.nombre        << endl
      << a.ape1          << endl
      << a.ape2          << endl
      << sZona           << endl;

}

void listado_arbitros(TListaArbitros &l)
{
  TArbitro a;
  bool vacia;
  TListaArbitros copia;

  duplicaLista(l,copia);
  
  while(!ListaArbitrosVacia(copia))
  {
    SacarMasAntiguo(copia,a,vacia);
    pintaArbitro(a);
  }
  DestruirListaArbitros(copia);
 
}

void asignaArbitro(TListaArbitros &l, TZona z1, TZona z2, TArbitro &a)
{
  bool vacia,ok;
  TListaArbitros copia;

  duplicaLista(l,copia);
  ok = false;
  
  while(!ListaArbitrosVacia(copia) && (!ok))
  {
    SacarMasAntiguo(copia,a,vacia);
    ok = (a.zona!=z1) && (a.zona!=z2);

  }
  DestruirListaArbitros(copia);
  BorrarArbitro(l,a.num_colegiado);
}

