#include "MEmpleado.h"
#include <stdlib.h>

namespace MListaEmpleado
{ 
  TListaEmpleado CrearListaEmpleado()
  { return NULL;
  }
  
  bool ListaEmpleadoVacia(TListaEmpleado l)
  { return (l==NULL);
  }
  
  void InsertarListaEmpleado(TListaEmpleado &l, TEmpleado emple)
  { TListaEmpleado aux;
    if ( (l==NULL) || (emple.num < l->e.num) )
    { aux = new (TNodoEmpleado);
      aux->e=emple;
      aux->sig=l;
      l = aux;
    }
    else
    { InsertarListaEmpleado(l->sig,emple);
    }
  }

  void BorrarListaEmpleado(TListaEmpleado &l, TNatural num)
  { TListaEmpleado aux;
    if (l==NULL)
    { // No est .. no hay que hacer nada
    }
    else if (l->e.num==num)
    { // encontrado
      aux = l;
      l = l->sig;
      delete(aux);
    }
    else if (l->e.num>num)
    { // No est .. no hay que hacer nada
    }
    else
    { BorrarListaEmpleado(l->sig,num);
    }    
  }
  
  void BuscarListaEmpleado(TListaEmpleado l, TNatural num, bool &encontrado,
                      TEmpleado &emple)
  { if (l==NULL)
    { encontrado =false;
    }
    else if (l->e.num==num)
    { encontrado = true;
      emple = l->e;
    }
    else if (l->e.num>num)
    { encontrado =false;
    }
    else
    { BuscarListaEmpleado(l->sig,num,encontrado,emple);
    }    
  }
                      
  void RangoListaEmpleados(TListaEmpleado l, TNatural &menor, TNatural &mayor)
  { TListaEmpleado ptr;
   
    if (ListaEmpleadoVacia(l))
    { menor = 0;
      mayor = 0;
    }
    else
    { menor = l ->e.num;     // porque estn ordenados por nmero      
      ptr = l;
      while(ptr!=NULL)
      { mayor = ptr->e.num;  // porque estn ordenados por nmero        
        ptr = ptr->sig;      
      }
    }
  }
    
  void DestruirListaEmpleado(TListaEmpleado &l)
  { TListaEmpleado aux;
  
    while (l!=NULL)
    { aux = l;
      l = l -> sig;
      delete(aux);
    }
            
  }

}



