#include "MEmpresa.h"
#include <stdlib.h>

namespace MEmpresa
{
  TEmpresa CrearEmpresa()
  { return NULL;
  }
  
  bool EmpresaVacia(TEmpresa e)
  { return (e==NULL);
  }
  
  
  void InsertarEmpleado(TEmpresa &e, TEmpleado emple, TCadena depto)
  { TEmpresa ptr;
    bool nuevo;

    ptr = e;
    while ( (ptr!=NULL) && (!IgualCadena(ptr->nombre_dpto,depto)) )
    { ptr = ptr -> sig_depto;
    }
    
    if (ptr==NULL) // El departamento es nuevo
    { ptr = new(TDepto);
      CopiaCadena(depto,ptr->nombre_dpto);
      ptr -> num_emp = 0;
      ptr ->lista = CrearListaEmpleado();
      ptr ->sig_depto = e;
      e = ptr;
    }
  
    InsertarListaEmpleado(ptr->lista,emple);
    ptr->num_emp = ptr->num_emp +1;
  }
  
  void BorrarEmpleado(TEmpresa &e, TNatural num)
  { TEmpresa aux,ant,ptr;
    TEmpleado emple;

    ptr = e;
    ant = NULL;
    
    while (ptr!=NULL)
    { BorrarListaEmpleado(ptr->lista,num);
      if (ListaEmpleadoVacia(ptr->lista))
      {                 // hay que borrar el dpto
        aux = ptr ;     // nodo a borrar
        if (ant==NULL)  // hay que borrar el 1
        { e = e-> sig_depto;
        }
        else            // hay que borrar uno intermedio
        { ant -> sig_depto = ptr ->sig_depto;
        }
        ptr = aux->sig_depto;
        delete(aux);        
      }
      else
      { ptr = ptr-> sig_depto;
      }
    }

  }
  
  void BuscarEmpleado(TEmpresa e, TNatural num, bool &encontrado,
                      TEmpleado &emple, TCadena &depto)
  { TEmpresa ptr;

    ptr = e;
    encontrado = false;
    
    while ( (ptr!=NULL) && (!encontrado) )
    { BuscarListaEmpleado(ptr->lista,num,encontrado,emple);
      if (encontrado)
      { CopiaCadena(depto,ptr->nombre_dpto);
      }
      else
      { ptr = ptr -> sig_depto;
      }
    }
    
  }
  
  void RangoEmpleados(TEmpresa e, TNatural &menor, TNatural &mayor)
  { TEmpresa ptr;
    bool inicializados;
    TNatural min,max;
    
    menor = 0;
    mayor = 0;
    ptr = e;
    inicializados = false;
    
    while (ptr!=NULL)
    { 
      if (!ListaEmpleadoVacia(ptr->lista))
      { RangoListaEmpleados(ptr->lista,min,max);
    
        if (!inicializados)
        { mayor = max;
          menor = min;
          inicializados = true;
        }
        else 
        { if (max > mayor)
          { mayor = max;
          }
          if (min < menor)
          { menor = min;
          }        
        }
      }
      ptr = ptr -> sig_depto;
    }
        
  }
  
  void DestruirEmpresa(TEmpresa &e)
  { TEmpresa aux;

    while (e!=NULL)
    { aux = e;
      e = e -> sig_depto;
      DestruirListaEmpleado(aux->lista);
      delete (aux);
    }
  }
  
}



