-------------------------------------------------------------------------------
-- Árboles Binarios de Búsqueda
--
-- Ampliación de Programación
-- Pepe Gallardo, 2010
-------------------------------------------------------------------------------

module BinarySearchTree ( Tree
                         , insert
                         , toSearchTree  
                         , inOrder
                         , height
                         , size 
                         , every
                         ) where

import Test.QuickCheck


data Tree a = Empty | Node (Tree a) a Int (Tree a) 

insert :: Ord a => a -> Tree a -> Tree a
insert x Empty  = Node Empty x 1 Empty
insert x (Node l v c r)
  | x == v      = Node l v (c+1) r
  | x < v       = Node (insert x l) v c r
  | otherwise   = Node l v c (insert x r)


toSearchTree :: Ord a =>  [a] -> Tree a
toSearchTree  = foldr insert Empty


inOrder :: Tree a -> [(a,Int)]
inOrder  = foldTreeAc (\v c -> ((v,c):)) [] 


foldTree :: (b -> a -> Int -> b -> b) -> b -> (Tree a -> b)
foldTree f z  = go
  where 
     go Empty           = z
     go (Node l v c r)  = f (go l) v c (go r)


foldTreeAc :: (a -> Int -> b -> b) -> b -> (Tree a -> b)
foldTreeAc f z t  = go t z
  where 
     go Empty ac           = ac
     go (Node l v c r) ac  = go l (f v c (go r ac))


height :: Tree a -> Int
height  = foldTree (\hL _ _ hR -> 1 + max hL hR) 0


size :: Tree a -> Int
size  = foldTree (\sL _ c sR -> sL + c + sR) 0 


every :: (a -> Bool) -> Tree a -> Bool
every p Empty           = True
every p (Node l v c r)  = p v && every p l && every p r


-- Al construir un árbol, obtenemos un árbol de búsqueda
prop_toSearchTreeOK xs  =
  True ==> isSearchTree (toSearchTree xs)
  where
    isSearchTree Empty           = True
    isSearchTree (Node l v c r)  = every (<= v) l
                                    && every (> v) r
                                    && isSearchTree l
                                    && isSearchTree r
  
-- Al construir un árbol de búsqueda en orden y recorrerlo `inOder', 
-- los valores están ordenados
prop_inOrderOK xs  = 
 True ==> enOrden . map fst . inOrder . toSearchTree $ xs
  where
    enOrden []        = True
    enOrden [x]       = True
    enOrden (x:y:zs)  = (x <= y) && enOrden (y:zs)

