-------------------------------------------------------------------------------
-- Conteo de palabras en un fichero de texto
--
-- Ampliación de Programación
-- Pepe Gallardo, 2010
-------------------------------------------------------------------------------

module Main where

import Char (isAlpha)


import System.Environment (getArgs)
import System.Exit (exitFailure)

import BinarySearchTree
import Tokenizer


palabras :: String -> [String]
palabras = tokens (not . isAlpha)

conteo :: [String] -> [(String,Int)]
conteo = inOrder . toSearchTree

formateo ::  [(String,Int)] -> String
formateo xs = concat [ linea p n | (p,n) <- xs ]
 where
  maxLong = maximum  [ length p | (p,n) <- xs ]
  linea p n = concat [ p, espacios, " : ", barras, "\n" ]
    where
      espacios = replicate (maxLong - length p) ' '
      barras   = replicate n '*'

main :: IO ()
main = do
   fn <- argumento
   xs <- readFile fn
   let str = formateo . conteo . palabras $ xs
   putStr str
 `catch` \e -> print e

argumento :: IO String
argumento = do
 as <- getArgs  -- getArgs :: IO [String]
 case as of
    [fn] -> return fn
    _    -> do 
              putStrLn "Uso: Palabras <fichero>"
              exitFailure

