-------------------------------------------------------------------------------
-- Ejemplos con QuickCheck
--
-- Ampliación de Programación
-- Pepe Gallardo, 2010
-------------------------------------------------------------------------------

module QuickSort (qSort) where

import List ((\\))
import Test.QuickCheck

qSort :: (Ord a) => [a] -> [a]
qSort []      = []
qSort (p:xs)  = qSort ys ++ [p] ++ qSort zs
  where
    ys = [ x | x <- xs, x <= p ]
    zs = [ x | x <- xs, x > p ]



-- La ordenación es idempotente
prop_idempot xs  = 
  True ==> qSort (qSort xs) == qSort xs

-- Para lista no vacías, la cabeza de la lista ordenada es 
-- el mínimo elemento de la lista original
prop_min xs  = 
  not (null xs) ==> head (qSort xs) == minimum xs

-- Para lista no vacías, el último elemento de la lista ordenada 
-- es el máximo elemento de la lista original
prop_max xs  = 
  not (null xs) ==> last (qSort xs) == maximum xs

-- Tras ordenar una lista, la lista está en orden
prop_ordenada xs  =
  True ==> enOrden (qSort xs)
  where
    enOrden []        = True
    enOrden [x]       = True
    enOrden (x:y:zs)  = (x <= y) && enOrden (y:zs)

-- La lista ordenada es una permutación de la original
prop_permuta xs  =
  True ==> qSort xs `esPermutaciónDe` xs
  where
    xs `esPermutaciónDe` ys  = null (xs \\ ys) && null (ys \\ xs)

 