-------------------------------------------------------------------------------
-- Repaso `Ampliado' de Programación Declarativa
--
-- Ampliación de Programación
-- Pepe Gallardo, 2010
-------------------------------------------------------------------------------

import Prelude hiding ( id, const, fst, snd, length, (++)
                       , elem, maximum
                       , map, filter
                       , (.), ($)
                       , foldr, takeWhile, dropWhile, span, sum, product
                       ) 
import Test.QuickCheck
-------------------------------------------------------------------------------
-- Recursividad, patrones, guardas, definiciones locales

fact :: Integer -> Integer
fact 0         = 1
fact n
  | n > 0      = n * fact (n-1)
  | otherwise  = error "argumento negativo"

-- Con acumulador
fact' :: Integer -> Integer
fact' n = f n 1
  where
    f 0 ac         = ac
    f n ac
      | n > 0      = f (n-1) (ac*n)
      | otherwise  = error "argumento negativo"

{-

fact' 3 
 => f 3 1
 => f 2 (1*3)
 => f 1 ((1*3)*2)
 => f 0 (((1*3)*2)*1)
 => 1*3*2*1
 => 6

-}

-------------------------------------------------------------------------------
-- Polimorfismo

id :: a -> a
id x  = x

const :: a -> b -> a
const x _  = x

fst :: (a,b) -> a  -- Tuplas
fst (x,_)  = x

snd :: (a,b) -> b
snd (_,y)  = y


-------------------------------------------------------------------------------
-- Listas

length :: [a] -> Int  -- Listas
length []      = 0
length (_:xs)  = 1 + length xs

infixr 5 ++
(++) :: [a] -> [a] -> [a]
[]     ++ ys  = ys
(x:xs) ++ ys  = x : (xs ++ ys)

prop_Neutro_Der xs = 
  True ==> xs ++ [] == xs

prop_Rev xs ys =
  True ==> reverse xs ++ reverse ys == reverse (ys ++ xs)
















-------------------------------------------------------------------------------
-- Funciones de orden superior

map :: (a -> b) -> [a] -> [b]
map f []      = []
map f (x:xs)  = f x : map f xs


filter :: (a -> Bool) -> [a] -> [a]
filter p []    = []
filter p (x:xs) 
  | p x        = x : filter p xs
  | otherwise  = filter p xs


ej0 = map (\x -> 2*x) [1..10] -- Funciones lambda o anónimas

ej1 = map (2*) [1..10] -- secciones

-- Currying y Aplicación parcial
ej2 = map (const 100) [1..10]  -- como          const x _  = x
                               -- tenemos que   const      = \x -> (\_ -> x)
                               -- por lo que    const x    = \_ -> x
                               -- y             const 100  = \_ -> 100


-------------------------------------------------------------------------------
-- Listas por comprensión

map' :: (a -> b) -> [a] -> [b]
map' f xs  = [ f x | x <- xs ]

filter' :: (a -> Bool) -> [a] -> [a]
filter' p xs  = [ x | x <- xs, p x ]


-------------------------------------------------------------------------------
-- Composición y aplicación de funciones

infixr 9  .
(.) :: (b -> c) -> (a -> b) -> (a -> c)
f . g  = \x -> f (g x)

infixr 0  $
($) :: (a -> b) -> a -> b
f $ x  = f x

ej3 :: Int
ej3  = (^2) . (*2) . (+1)  $ 10     -- devuelve ((10+1)*2)^2

ej4 :: [Int]
ej4  = map (^2) . map (*2) . map (+1)  $ [10,11,12] 


-------------------------------------------------------------------------------
-- Ver clases


-------------------------------------------------------------------------------
-- Definiciones de Tipo

data Color = Rojo | Verde | Azul deriving Show

colores :: [Color]
colores = [Rojo, Verde, Azul]

instance Eq Color where
  Rojo  == Rojo   = True
  Verde == Verde  = True
  Azul  == Azul   = True
  _     == _      = False

instance Ord Color where
  Rojo  <= _      = True
  Verde <= Verde  = True
  Verde <= Azul   = True
  Azul  <= Azul   = True
  _     <= _      = False


data Nat = Cero | Suc Nat deriving Show

uno, dos, tres :: Nat
uno   = Suc Cero
dos   = Suc (Suc Cero)
tres  = Suc (Suc (Suc Cero))

instance Eq Nat where
  Cero  == Cero   = True
  Suc x == Suc y  = x == y
  _     == _      = False

instance Ord Nat where
  Cero  <= _      = True
  Suc x <= Suc y  = x <= y
  _     <= _      = False

instance Num Nat where
  Cero  + y  = y
  Suc x + y  = Suc (x+y)

  Cero  * _  = Cero
  Suc x * y  = x*y  +  y 

  x     - Cero   = x
  Cero  - Suc _  = error "valor negativo"
  Suc x - Suc y  = x - y 

  abs x  = x

  signum Cero     = Cero
  signum (Suc _)  = uno

  fromInteger 0      = Cero
  fromInteger (n+1)  = Suc (fromInteger n)

-------------------------------------------------------------------------------
-- Registros

data Persona = Pers { nombre :: String
                     , edad :: Int
                     } deriving Show

juan :: Persona
juan  = Pers { nombre = "Juan"
             , edad = 20
             }

envejece :: Persona -> Persona
envejece Pers{nombre=n, edad=e}  = Pers{nombre=n, edad=e+1}

envejece' :: Persona -> Persona
envejece' p@Pers{edad=e}  = p{edad=e+1}



-------------------------------------------------------------------------------
-- Sobrecarga

doble :: (Num a) => a -> a  -- Tipos numéricos
doble x  = x + x

elem :: (Eq a) => a -> [a] -> Bool  -- Tipos con igualdad
elem y []      = False
elem y (x:xs)  = y==x  ||  elem y xs

maximum :: (Ord a) => [a] -> a   -- Tipos con orden
maximum []     = error "Lista vacía"
maximum [x]    = x
maximum (x:xs) = max x (maximum xs)


-------------------------------------------------------------------------------
-- Plegados

foldr :: (a -> b -> b) -> b -> ([a] -> b)
foldr f z  = go
  where
    go []      = z
    go (x:xs)  = f x (go xs)

sum :: (Num a) => [a] -> a
sum = foldr (\x s -> x+s) 0

sum' :: (Num a) => [a] -> a
sum' = foldr (+) 0

product :: (Num a) => [a] -> a
product = foldr (*) 1

length' :: [a] -> Int
length'  = foldr (\_ n -> n + 1) 0

length'' :: [a] -> Int
length''  = foldr (const (+1)) 0  
  -- ya que   \_ n -> n+1  =  \_ -> (\n -> n+1) =  \_ -> (+1)  =  const (+1)

elem' :: (Eq a) => a -> [a] -> Bool
elem' y  = foldr (\x b -> x==y || b) False


-------------------------------------------------------------------------------
-- Más funciones de orden superior

takeWhile :: (a -> Bool) -> [a] -> [a]
takeWhile p []  = []
takeWhile p (x:xs)
  | p x         = x : takeWhile p xs
  | otherwise   = []

dropWhile :: (a -> Bool) -> [a] -> [a]
dropWhile p []  = []
dropWhile p (x:xs)
  | p x         = dropWhile p xs
  | otherwise   = x:xs

span :: (a -> Bool) -> [a] -> ([a],[a])
span p xs  = (takeWhile p xs, dropWhile p xs)




