﻿-- Pepe Gallardo,   2003

-- Acierta un número.

import Monad (when)
import Random
import AP.Cgi
import Links

-- Algunos estilos

baseCss = [ pFontFamily =: value "Arial" ]
        
bodyCss = 
 baseCss <+> [ pFontSize =: percent 100 ]

titleCss = 
 baseCss <+> [ pColor =: vPurple
  	     , pFontWeight =: vBold
   	     , pFontSize =: percent 120
   	     ]

footerCss = 
 baseCss <+> [ pColor =: vWhite
	     , pBackgroundColor =: vBlue
	     , pFontWeight =: vBold
             , pFontSize =: percent 60	     ]



-- Genera una página HTML dados su título y cuerpo
page :: String -> Html () -> Html ()
page title body =
  hHtml $
     do { hHead $ hTitle $ hText title
        ; hBody $ 
           hCenter $
            do { withCss titleCss $ hSpan $ hText title
               ; hBr 
               ; withCss bodyCss $ hDiv $ body
               ; hBr
               ; hBr
               ; withCss footerCss $ hSpan $ hText "Página generada con Haskell y Ap.Cgi"
               }
        }


-- Genera un formulario
form :: String -> Html () -> Cgi ()
form title body =
 ask $ page title (hForm body)


-- Valores máximo y mínimo del número
minV :: Int     	
minV = 0 
maxV :: Int     	
maxV = 100


inicio :: Cgi ()
inicio =
 form "Bienvenido" $
   do { v <- safeIO $ randomRIO (minV,maxV)
      ; hText "Dame tu nombre: "
      ; nombre <- hTextInput 
      ; hBr 
      ; hBr
      ; hButtonInput "Comenzar" (acierta [] v nombre)
      }


acierta :: [Int] -> Int -> String -> Cgi ()
acierta xs n nombre =
 form "Acierta el número" body
  where
   body =  
     do { pintaIntentos xs n
     	; hText $ nombre ++", acierta un número entre " ++show minV++ " y "++show maxV++": "
        ; hBr
        ; hBr
        ; n' <- hTextInput
        ; hButtonInput "Jugar" (juega xs n n' nombre)
        }


juega :: [Int] -> Int -> Int -> String -> Cgi ()
juega xs n n' nombre
  | n' == n   = tell $ page "Acertaste" $ 
                  do { hBr 
                     ; hText $ "Felicidades "++nombre
                     ; hBr
                     ; hBr
                     ; let xs' = xs++[n]
                     ; pintaIntentos xs' n
                     ; hText $ "En total "++show (length xs') ++ " intentos"
                     ; hBr
                     ; hBr
                     ; linkThisCgi "Volver a jugar"
                     }
                                            
  | otherwise = (acierta (xs++[n']) n nombre)

pintaIntentos :: [Int] -> Int -> Html ()
pintaIntentos xs n =
 when (not (null xs)) $
   do { hText "Has realizado los siguientes intentos: "
      ; hBr
      ; mapM_ aprox xs
      ; hBr
      ; hBr
      }
  where
   aprox v = do { hBr
                ; withCss css $ hSpan $ hText $ show v ++ if v>n then " Alto" 
                                                          else if v<n then " Bajo" 
                                                          else " Correcto"
                }
    where
     css = baseCss <+> 
            [ pColor =: if v>n then vRed else if v<n then vBlue else vGreen
            , pFontSize =: percent 75
            ]

main :: IO ()
main = runCgi inicio

