﻿-- Pepe Gallardo,   2003

-- Contador interactivo

import AP.Cgi

-- Genera una página HTML dados su título y cuerpo
page :: String -> Html () -> Html ()
page title body =
  hHtml $
     do { hHead $ hTitle $ hText title
        ; hBody $ 
           hCenter $
            do { hB $ hText title
               ; hBr 
               ; body
               }
        }


contador :: Int -> Cgi ()
contador n =
 ask $ page "Contador" body
  where
   body =  hForm $ 
             do { hButtonInput "Decrementar" (contador (n-1))
                ; hText " "; hShow n; hText " "
                ; hButtonInput "Incrementar" (contador (n+1))
                }

main :: IO ()
main = runCgi (contador 0)