﻿-- Pepe Gallardo,   2003

-- Tutorial de distintos controles.

import AP.Cgi

-- Estilos de los distintos elementos

baseCss = [ pFontFamily =: value "Verdana, Arial"]

pageCss = baseCss <+> [ pFontSize =: percent 90 ]

titleCss = baseCss <+> [ pColor =: vPurple
  	               , pFontWeight =: vBold
   	               , pFontSize =: percent 110
   	               ]

footerCss = baseCss <+> [ pColor =: vWhite
	                , pBackgroundColor =: vBlue
	                , pFontWeight =: vBold
 	                , pFontSize =: percent 70
	                ]


-- Genera una página HTML dados su título y cuerpo
page :: String -> Html () -> Html ()
page title body =
  withCss pageCss $ hHtml $
     do { hHead $ hTitle $ hText title
        ; hBody $ 
           hCenter $
            do { withCss titleCss $ hSpan $ hText title
               ; hBr 
               ; body
               ; hBr
               ; hBr
               ; withCss footerCss $ hSpan $ hText "Página generada con Haskell y AP.Cgi"
               }
        }


-- Genera un formulario dados su título y cuerpo
form :: String -> Html () -> Cgi ()
form title body =
 ask $ page title (hForm body)




hButtonInputDemo :: Cgi ()
hButtonInputDemo = 
 form "hButtonInput" $
  do { hText "Pulsa uno de los botones"
     ; hBr ; hBr
     ; hButtonInput "Uno" (seguirButton "Botón uno")
     ; hButtonInput "Dos" (seguirButton "Botón dos")
     }


seguirButton :: String -> Cgi ()
seguirButton msg =
 form "hButtonInput" $
  do { hText $ "Has pulsado el " ++ msg
     ; hBr ; hBr
     ; hButtonInput "Seguir" (hTextInputDemo)     
     }


hTextInputDemo :: Cgi ()
hTextInputDemo =
 form "hTextInput y hPasswordInput" $
 do { hText "Introduce tu nombre: "
    ; n <- hTextInput 
    ; hBr    
    ; hText "Introduce tu edad: "
    ; e <- hTextInput 
    ; hBr    
    ; hText "Introduce tu password: "
    ; p <- hPasswordInput
    ; hBr ; hBr   
    ; hButtonInput "Seguir" (leerTextInput n e p)         
    }


leerTextInput :: String -> Int -> String -> Cgi ()
leerTextInput n e p = 
 form "hTextInput y hPasswordInput" $
  do { hText "Tu nombre es " 
     ; hText n
     ; hText " y tu edad es "
     ; hShow e
     ; hText " y tu password es "
     ; hText p
     ; hBr ; hBr
     ; hButtonInput "Seguir" (hTextAreaInputDemo)     
     }


hTextAreaInputDemo :: Cgi ()
hTextAreaInputDemo =
 form "hTextAreaInput" $
 do { hText "Introduce un texto"
    ; hBr
    ; txt <- hTextAreaInput 20 30
    ; hBr ; hBr   
    ; hButtonInput "Seguir" (leerTextArea txt)         
    }


leerTextArea :: String -> Cgi ()
leerTextArea txt = 
 form "hTextAreaInput" $
  do { hText "El texto introducido fue" 
     ; hBr
     ; hPre $ hText txt
     ; hBr ; hBr
     ; hButtonInput "Seguir" (hSelectInputDemo)     
     }


data Día = Lunes | Martes | Miercoles | Jueves | Viernes | Sábado | Domingo 
           deriving (Show,Read,Enum)

instance CgiInput Día -- Esta instancia y el deriving (Show,Read) son imprescindibles
                      -- para poder usar los controles con este tipo


hSelectInputDemo :: Cgi ()
hSelectInputDemo =
 form "hSelectInput" $
  do { hText "Elige una opción"
     ; hBr ; hBr
     ; d <- hSelectInput [ Lunes .. Domingo ] 
     ; hBr ; hBr                             
     ; hButtonInput "Seguir" (leerSelectInput d)
     }


leerSelectInput :: Día -> Cgi ()
leerSelectInput d =
 form "hSelectInput" $
  do { hText "Has seleccionado la opción "
     ; hShow d
     ; hBr ; hBr
     ; hButtonInput "Seguir" (hRadioGroupInputDemo)     
     }


hRadioGroupInputDemo :: Cgi ()
hRadioGroupInputDemo =
 form "hRadioGroupInput" $
  do { hText "Elige una opción"
     ; hBr ; hBr
     ; d <- hRadioGroupInput [ (hShow opt, opt) 
                             | opt <- [Lunes .. Domingo] 
                             ]
     ; hBr ; hBr                             
     ; hButtonInput "Seguir" (leerRadioGroup d)
     }


leerRadioGroup :: Día -> Cgi ()
leerRadioGroup d =
 form "hRadioGroupInput" $
  do { hText "Has seleccionado la opción "
     ; hShow d
     ; hBr ; hBr
     ; hButtonInput "Seguir" (hCheckBoxInputDemo)
     }


hCheckBoxInputDemo :: Cgi ()
hCheckBoxInputDemo =
 form "hCheckBoxInput" $
  do { hText "Marca las opciones que quieras"
     ; hBr ; hBr
     ; let días = [ Lunes .. Domingo ]
     ; bs <- sequence [ do { b <- hCheckBoxInput
                           ; hShow opt
                           ; return b
                           }
                      | opt <- días
                      ] 
     ; hBr ; hBr                             
     ; hButtonInput "Seguir" (leerCheckBox (zip bs días))
     }


leerCheckBox :: [(Bool,Día)] -> Cgi ()
leerCheckBox ds =
 form "hCheckBoxInput" $
  do { hText "Las opciones seleccionadas son: "
     ; hBr ; hBr
     ; hShow [ d | (True,d) <- ds ]
     ; hBr ; hBr   
     ; hButtonInput "Seguir" (hImageInputDemo)
     }


hImageInputDemo :: Cgi ()
hImageInputDemo =
 form "hImageInput" $
  do { hText "Haz click en un punto sobre la imagen"
     ; hBr
     ; hImageInput "dormitorio.jpg" (leerImageInput)     
     }

leerImageInput :: (Int,Int) -> Cgi ()
leerImageInput (x,y) =
 tell $ page "hImageInput" $
  do { hBr
     ; hText "Has hecho click en el punto "
     ; hShow (x,y)
     }



main :: IO ()
main = runCgi hButtonInputDemo

