﻿-- Pepe Gallardo, 2003

-- Enlaza con todos los ejemplos


import AP.Cgi
import Links
import IO
import Monad (when)
import HaskellPretty

-- Comprueba si existe un fichero
fileExists :: FilePath -> IO Bool
fileExists path =
 do { readFile path 
    ; return True
    } 
    `catch` \e -> if isDoesNotExistError e then return False else ioError e


-- Genera una página HTML dados su título y cuerpo
page :: String -> Html () -> Html ()
page title body =
  hHtml $
   do { hHead $ hTitle $ hText title
      ; hBody $ withCss bodyCss $ hDiv body
      }
    where     
     bodyCss = [ pFontFamily  =: value "Arial"
   	       , pFontSize    =: 13
	       ]
	       
 	       

titleStr = "Ejemplos con AP.Cgi"


title :: Html ()
title = withCss titleCss $ hSpan $ 
         do { hText titleStr
            ; hBr
            ; hBr
            }
 where
   titleCss = [ pFontFamily  =: value "Arial"
 	      , pFontSize    =: 30
              , pColor       =: vRed
              , pFontWeight  =: vBold
              ]


mainPage :: Html ()
mainPage = 
 page titleStr $
  hForm $ 
  do { title
     ;  hUl $
        do { sequence_ [ withCss [pPaddingBottom =: px 10] $ hLi $ myLink file msg 
                       | (file,msg) <- [ ("HolaMundo",        "Hola Mundo")
                                       , ("FormularioSimple", "Un formulario simple")
                                       , ("Calendario",       "Un calendario")
                                       , ("Contador",         "Un contador")
                                       , ("Tabla",            "Tablas HTML")
                                       , ("Controles",        "Los controles disponibles")
                                       , ("AciertaNumero",    "Acierta un número")
                                       , ("Tablon",           "Un tablón de mensajes")
                                       , ("Pretty",           "Formateador de programas Haskell")
                                       , ("Buscador",         "Un buscador para una tienda")
                                       ]
                       ]                
           }
     }


myLink file msg =
 do { let exeFile = file++".exe"
    ; let hsFile  = file++".hs"
    ; exe <- unsafeIO $ fileExists exeFile
    ; hs  <- unsafeIO $ fileExists hsFile
    ; link (if exe then exeFile else hsFile) msg
    ; when hs $ withCss [ pFontSize =: 10
                        , pFontFamily =: value "Arial"
                        ] $ hButtonInput "Ver fuente" (tell $ haskellPrettyFile hsFile) 
    }

main :: IO ()
main = runCgi (ask mainPage)

