﻿-- Pepe Gallardo,   2003

-- Un ejemplo básico de formulario

import AP.Cgi

-- Genera una página HTML dados su título y cuerpo
page :: String -> Html () -> Html ()
page title body =
  hHtml $
     do { hHead $ hTitle $ hText title
        ; hBody $ 
           hCenter $
            do { hB $ hText title
               ; hBr 
               ; body
               }
        }

formulario1 :: Cgi ()
formulario1 =
 ask $ page "Formulario 1" $
  hForm $
   do { hText "Dame tu nombre: "
      ; nombre <- hTextInput
      ; hBr ; hBr
      ; hButtonInput "Enviar" (formulario2 nombre)
      }

formulario2 :: String -> Cgi ()
formulario2 nombre =
 ask $ page "Formulario 2" $
  hForm $
   do { hText nombre
      ; hText ", dame tu edad: "
      ; edad <- hTextInput
      ; hBr ; hBr
      ; hButtonInput "Enviar" (páginaFinal nombre edad)
      }

páginaFinal :: String -> Int -> Cgi ()
páginaFinal nombre edad =
 tell $ page "Página final" $
  do { hBr
     ; hText "Te llamas "
     ; hText nombre
     ; hText " y tu edad es "
     ; hShow edad
     }

main :: IO ()
main = runCgi formulario1