﻿-- Pepe Gallardo,   2003

-- Utilidades para hiperenlaces

module Links 
  ( link
  , linkThisCgi
  , backLink
  , forwardLink
  ) where

import AP.Cgi
import System(getEnv)
	
-- Genera un hiperenlace
link :: String -> String -> Html ()
link url str =
  withCss  [ pTextDecoration =: vNone
           , pColor          =: rgb 00 51 153
           ] $
  withAttr [ pHRef =: value url
           ] $ hA $ hText $ "["++str++"]"
	
-- Genera un hiperenlace al propio CGI_
linkThisCgi :: String -> Html ()
linkThisCgi str =
 do { myURL <- unsafeIO $ getEnv scriptName           
    ; link myURL str
    }

-- Genera un hiperenlace a la página previa	
backLink :: String -> Html ()
backLink = link "javascript:history.go(-1)"

-- Genera un hiperenlace a la página siguiente
forwardLink :: String -> Html ()
forwardLink = link "javascript:history.go(1)"
 