﻿-- Pepe Gallardo, 2003

-- Muestra un fichero fuente Haskell resaltando la sintaxis


import AP.Cgi
import Links
import IO
import Monad (when)
import HaskellPretty


-- Genera una página HTML dados su título y cuerpo
page :: String -> Html () -> Html ()
page title body =
  hHtml $
   do { hHead $ hTitle $ hText title
      ; hBody $ withCss bodyCss $ hDiv body
      }
    where     
     bodyCss = [ pFontFamily  =: value "Arial"
	       ]
	       
 	       

titleStr = "Formateador de Haskell"


title :: Html ()
title = withCss titleCss $ hSpan $ 
         do { hText titleStr
            ; hBr
            ; hBr
            }
 where
   titleCss = [ pFontFamily  =: value "Arial"
 	      , pFontSize    =: percent 200
              , pColor       =: vRed
              , pFontWeight  =: vBold
              ]


mainPage = 
 ask $
 page titleStr $
  hForm $ 
  do { title
     ; hText "Introduzca en la caja su código fuente en Haskell"
     ; hBr
     ; hBr
     ; str <- withCss [pFontSize =: percent 60] $ withAttr [ aNoWrap ] $ hTextAreaInput 15 100
     ; hBr
     ; hBr
     ; hButtonInput "Formatear" (showHaskell str)
     }


showHaskell str =
 tell $
 page titleStr $
  do { title
     ; haskellPrettyString str
     ; hBr
     ; linkThisCgi "Volver al formulario"
     }


main :: IO ()
main = runCgi mainPage

