﻿-- Pepe Gallardo, 2003

-- Ejemplos de tablas Html


import AP.Cgi


-- Algunos estilos

-- estilo base
baseCss = [ pFontFamily =: value "Arial"
          , pFontSize =: percent 100
          ]

-- estilo para formatear las tablas 	
tableCss = 
 baseCss <+> [ pBorder =: px 2 |+| vSolid
             , pBorderColor =: vBlue
             , pBorderCollapse =: vCollapse
             , pTextAlign =: vCenter
             ]

-- atributos para formatear cada celda
cellCss =  [ pBorder =: px 1 |+| vSolid
           , pBorderColor =: vBlack
           , pPaddingTop =: pt 2
           , pPaddingBottom =: pt 2
           , pPaddingLeft =: pt 8
           , pPaddingRight =: pt 8
           ]

-- atributos para formatear la cabecera	
headerCss = 
  cellCss <+> [ pColor =: vWhite
              , pBackgroundColor =: vRed
              , pFontWeight =: vBold
              ]

-- Genera una página HTML dados su título y cuerpo
page :: String -> Html () -> Html ()
page title body =
  hHtml $
     do { hHead $ hTitle $ hText title
        ; hBody $ hCenter $ body
        }

-- Para crear columnas de la tabla
hColumn :: String -> Html ()
hColumn x = withCss cellCss $ hTd $ hText x


-- Para crear la cabecera de la tabla
hHeader :: Html a -> Html a
hHeader x = withCss headerCss $ hTr x	


-- Definimos una tabla
tabla1 :: Html ()
tabla1 = 
 withCss tableCss $ hTable $ 
  do { hHeader $ do { hColumn "Columna 1"  ; hColumn "Columna 2" }
     ; hTr     $ do { hColumn "Uno"        ; hColumn "Dos"       }
     ; hTr     $ do { hColumn "Tres"       ; hColumn "Cuatro"    }
     ; hTr     $ do { hColumn "Cinco"      ; hColumn "Seis"      }
     }


-- Otra tabla	
tabla2 :: Html ()
tabla2  = 
  withCss tableCss $ hTable $ 
  do { hHeader $ sequence [ hColumn ("Columna " ++ show i) | i <- [1..5] ] 
     ; hRow [ 11 .. 15 ]
     ; hRow [ 21 .. 25 ]
     ; hRow [ 31 .. 35 ]
     ; return ()
     }
  where
   hRow xs = hTr $ sequence [ hColumn (show i) | i <- xs ]	
   
-- Una página con las tablas
pageTabla :: Html ()
pageTabla = 
 page "Ejemplos de tablas" $
   do { hText "Ejemplos con tablas HTML"
      ; hBr
      ; hBr
      ; tabla1
      ; hBr
      ; tabla2
      }

main :: IO ()
main = runCgi (tell pageTabla)

