﻿-- Pepe Gallardo,   2003

-- Tablón interactivo con mensajes.

import AP.Cgi  
import Links
import List (intersperse)
import System (getEnv)
import Time

-- Nombre del fichero con los mensajes
file :: String
file = "tablon.txt"


-- manejo de iconos
type IconIndex = Int

icon :: IconIndex -> Html ()
icon n = withCss [ pBackgroundColor =: rgb 250 250 250 
                 ] $
         withAttr [ pAlign =: vTop
                  , pSrc =: value ("icons/icon_"++show n++".gif") 
                  ] $ hImg 


-- Los colores
data Color = Rojo | Verde | Azul | Magenta deriving (Show,Read,Enum)
instance CgiInput Color

colorToValue :: Color -> Value
colorToValue c = [vRed, vGreen, vBlue, vPurple] !! fromEnum c


-- tipo para representar un mensaje
data Msg = Msg { from      :: String
               , date      :: CalendarTime 
               , urlFrom   :: String
               , iconIndex :: IconIndex
               , color     :: Color
               , body      :: String
               } deriving (Show,Read)


-- Genera una página HTML dados su título y cuerpo
page :: String -> Html () -> Html ()
page title body =
  hHtml $
     do { hHead $ hTitle $ hText title
        ; hBody $ hCenter $
            do { withCss titleCss $ hSpan $ hText title
               ; hBr 
               ; hBr
               ; hBr
               ; withCss bodyCss $ hDiv $ body
               ; hBr
               ; hBr
               ; withCss footerCss $ hSpan $ hText "Página generada con Haskell y AP.Cgi"
               }
        }

-- Genera un formulario
form :: String -> Html () -> Cgi ()
form title body =
 ask $ page title (withCss bodyCss $ hForm body)


-- Estilos
baseCss = [ pFontFamily =: value "Arial" ]

bodyCss = baseCss <+> [ pFontSize =: percent 90 ]

titleCss = 
 baseCss <+> [ pColor =: vPurple
  	     , pFontWeight =: vBold
   	     , pFontSize =: percent 180
   	     ]

footerCss = 
 baseCss <+> [ pColor =: vWhite
	     , pBackgroundColor =: vPurple
	     , pFontWeight =: vBold
	     , pFontSize =: percent 60
             , pPadding =: px 3
	     ]

cellCss = [ pPadding =: px 4 ] 

leftCss =
    cellCss <+>  
    [ pFontWeight =: vBold
    , pVerticalAlign =: vTop
    , pWidth =: percent 18
    ]

rightCss = 
    cellCss <+> 
    [ pWidth =: percent 82
    , pBackgroundColor =: rgb 232 232 232 
    ]

msgBodyCss color = 
    rightCss <+> 
    [ pColor =: color
    , pWidth =: px 300
    ]

tableCss color = 
    [ pBorder =: px 2 |+| vSolid |+| color
    , pBorderCollapse =: vCollapse
    , pBackgroundColor =: rgb 225 225 225
    , pFontSize =: percent 90
    ]

headerCss color = 
    [ pBackgroundColor =: color 
    , pColor =: vWhite
    , pFont =: percent 115
    , pFontWeight =: vBold
    ]


tablón :: Cgi ()
tablón =
 form "Tablón de mensajes" $ 
   do { str <- unsafeIO $ readFile file
      ; let msgs = map read $ lines str
      ; mapM mostrarMsg msgs
      ; hBr
      ; hButtonInput "Dejar mensaje" dejarMsg
      }


mostrarMsg :: Msg -> Html ()
mostrarMsg Msg{from=vFrom, date=vDate, urlFrom=vUrlFrom, iconIndex=vIconIndex, color=vColor, body=vBody} = 
 do { let c = colorToValue vColor
    ; mkTable c [ ( icon vIconIndex
                  , hText vFrom
                  )
                , ( hText "Enviado:"
                  , hText $ calendarTimeToString vDate
                  )
                , ( hText "Desde:"
                  , hText vUrlFrom
                  )
                , ( hText "Mensaje:"
                  , withCss (msgBodyCss c) $ hDiv $ sequence_ $ 
                     intersperse hBr $ map hText $ lines vBody
                  )
                ] 
    ; hBr
    ; hBr
    }
 where
  mkTable c ((hl,hr):xs) = 
   withCss (tableCss c) $ hTable $ 
    do { withCss (headerCss c) $ hTr $ do { hTd hl; hTd hr }
       ; sequence [ hTRow lr | lr <- xs ]
       }


hTRow :: (Html a,Html b) -> Html b  
hTRow (l,r) = hTr $ do { hTdLeft l; hTdRight r }
 where
  hTdLeft x = withCss leftCss $ hTd x
  hTdRight x = withCss rightCss $ hTd x


dejarMsg :: Cgi ()
dejarMsg = 
  form "Deja tu mensaje" $ withCss (tableCss vGreen ) $ hTable $ 
   do { vFrom <- hTRow ( hText "Tu nombre:" 
                       , hTextInput 
                       ) 
      ; vIconIndex <- hTRow ( hText "Elige un icono:" 
                            , hRadioGroupInput [ (icon i, i) | i <- [1..6] ]
                            )                              
      ; vColor <- hTRow ( hText "Elige un color:" 
                        , hSelectInput [Rojo .. Magenta]
                        )
      ; vBody <- hTRow ( hText "Tu mensaje:" 
                       , hTextAreaInput 10 40 
                       )                              
      ; hTRow ( hEmpty 
              , do { hBr 
                   ; hButtonInput "Mandar mensaje" $
                       do { clock <- unsafeIO $ getClockTime
                          ; vUrlFrom <- unsafeIO $ getEnv remoteHost
                          ; let msg = Msg { from = vFrom
                                          , date = toUTCTime clock
                                          , urlFrom = vUrlFrom  
                                          , iconIndex = vIconIndex
                                          , color = vColor
                                          , body = vBody
                                          }
                          ; mandar msg
                          }
                   }
              )
      }


mandar :: Msg -> Cgi ()
mandar msg = 
 tell $ page "Mensaje mandado" $
  do { safeIO $ appendFile file ('\n':show msg) 
     ; hText "Su mensaje"
     ; hBr
     ; hBr
     ; mostrarMsg msg
     ; hBr
     ; hText "se ha mandado"
     ; hBr
     ; hBr
     ; linkThisCgi "Inicio"
     }

 

main :: IO ()
main = runCgi tablón

