﻿-- #hide

-- Sergio Jimenez Gonzalez  (ult. modificación: 14/7/2003)
-- Titulación: Ing. Técnico en Informática de Sistemas
-- Proyecto fin de carrera.

-- |Módulo con las funciones principales para la inicialización del estado de la mónada y lectura, descomposición
-- y decodificación de los argumentos de entrada (en los casos que recibamos información de algún formulario)
module AP.Cgi.Lib.CgiBase(
  -- * Funciones básicas para el CGI.
    -- ** runCgi
	runCgi,

	{-| Ejemplo:

	@
	  	main :: IO ()
	  	main = runCgi programa
	 	  where
	 	    programa :: 'Cgi' ()
	  	    programa = ...
	@
	
	-}

    -- ** runCgiExt
        runCgiExt,

    -- ** Funciones especiales para formularios
	ask, askExt, 

    -- ** Presentación de páginas normales
	tell, tellExt,

    -- ** Variables de entorno disponibles.
    {- | En el módulo /CgiBase/ también están disponibles diferentes funciones definidas en el módulo /Var/.
     Estas funciones están relacionadas con los nombres de las variables de entorno que define Xitami al solicitar cualquier 
     página web o archivo del servidor.
    
     En el caso de utilizar otro servidor sólo hay que cambiar el valor de la variable asociada por el nuevo nombre
     creado por el servidor.
    
    	Ejemplo de utilización:
    
     @
     		do { valor \<- 'unsafeIO' $ getEnv 'serverName'
     		   ; ...
     	           }
     @
    
     /getEnv/ es una función predefinida en el módulo /System/ de la biblioteca de /Haskell/. Su definición es la
     siguiente:
     
     >	getEnv :: String -> IO String
    
     La función 'unsafeIO' pertenece a la clase 'IOAction', y permite realizar acciones de entrada\/salida  
     mientras se crea la página.
    -}
	module AP.Cgi.Lib.Var,

  -- * Creación de etiquetas HTML.
	-- ** Tipos básicos
		Cgi, Html, StateType(InClient,InServer), MethodType(..),	-- En vez de hacer un enlace al módulo, vamos a exportar cada una de las funciones explicitamente
	-- ** Clases definidas
		CgiInput(..), IOAction(..),
	-- ** Funciones para añadir atributos a una etiqueta
		withAttr, 
		withCss,		
	-- ** Funciones para crear las etiquetas
	  {- | Cada una de las siguientes funciones crean una etiqueta de apertura y de cierre (cuando sea necesario) 
	   de los elementos Html a los que hacen referencia. Es decir, una función como /hBody/ crea la etiqueta 
	   \<BODY\> en el documento final. Los casos excepcionales serán comentados en su definición.
	  
	   Todas aquellas etiquetas simples (aquellas que no tienen cierre, sólo apertura) tendrán tipo /Html ()/, 
	   puesto que no reciben ningún argumento. Las demás etiquetas tienen tipo 
	   /Html a -> Html a/, donde el primer argumento representa el contenido de dicha etiqueta 
	   (lo que se incluirá entre la apertura y el cierre de la misma).

	   Por lo tanto, todas aquellas funciones que no tengan una explicación detallada corresponden con la creación de 
	   las etiquetas HTML 4.0 cuyos nombres coinciden con el de la función definida (las demás tendrán un funcionamiento
	   especial).

	   La sintaxis utilizada es la siguiente:
	   	
		* Anteponer el carácter \'h\' a todas las funciones (para no crear confusión con otras funciones 
		predeterminadas del /Prelude/).
		
		* Utilizar la primera letra de cada palabra en mayúsculas, así como la de las palabras compuestas.
		
		* Los nombres compuestos se definen concatenando las palabras que intervienen en su definición (no hay
		ningún carácter de separación especial como pudiera ser \'_\').

		Ejemplos de funciones definidas:
		
		>	Etiqueta <BODY>		=>	Función hBody
		>	Etiqueta <NOFRAME>	=>	Función hNoFrame
		>	Etiqueta <BASEFONT>	=>	Función hBaseFont
		> 	Etiqueta <A>		=> 	Función hA

		Ejemplo de utilización:
		
		@
			programa :: 'Html' ()
			programa = do {funcionEtiquetaNormal funcionEtiquetaSimple
				      ;funcionEtiquetaNormal2 (do {'hText' \"Hola\"
								  ;...
							       }
				      )
				   }
			  where
		 	    funcionEtiquetaNormal :: 'Html' a -> 'Html' a
				...
		 	    funcionEtiquetaNormal2 :: 'Html' a -> 'Html' a
				...
		 	    funcionEtiquetaSimple :: 'Html' ()
				...
		@
	   		
		Ejemplo práctico:
		
		@	
			main :: IO ()
			main = 'runCgi' holaMundo
			  where
			    holaMundo :: 'Cgi' ()
			    holaMundo = 'tell' $ 'hHtml' $
			                  do { 'hHead' $ 'hTitle' $ 'hText' \"Hola\"
					     ; 'hBody' $ 'hText' \"Hola Mundo\"
					  }
		@
	  -}
	
	  -- *** Texto y valores mostrables
		hText, hEmpty, hShow,
	  -- *** Elementos más externos
		--hDocType, 
		hHtml, hHead,	hBody, hFrameSet,	
	  -- *** Elementos Head
		hBase, hIsIndex, hLink, hMeta,hScript, hStyle, hTitle, 
	  -- *** Elementos de bloque genéricos
		hAddress, hBlockQuote, hCenter, hDiv, hH1, hH2, hH3, hH4, hH5, hH6, hHr, hNoScript, hP, hPre,			
	  -- *** Elementos de Listas
		hDir, hDl, hDt, hDd, hLi, hMenu, hOl, hUl, 
	  -- *** Elementos de tablas
	  	hTable,	hCaption, hColGroup, hColGroupS, hCol, hTHead, hTFoot, hTBody, hTr, hTd, hTh,			
	  -- *** Formularios
	    -- **** Tipos y funciones especiales
	    	getFieldName, getSubmitName, SelectOption, tempFilePath, cgiCont, -- ¿Incluimos estos dos ultimos o no?
	    -- **** Campos y etiquetas de formularios
	  	hForm, hFormExt, hTextInput, hPasswordInput, hCheckBoxInput, hRadioGroupInput, --hRadioGroupInputExt,
		hFileInput, hHiddenInput, hPrimButtonInput, hSubmitInput, hResetInput, hButtonInput, hImageInput,
		hSelectInput, hSelectInputExt, hTextAreaInput, hTextAreaInputExt, 
	    -- **** Otros elementos de formularios
		hButton, hFieldSet, hLegend, hLabel, hOptGroup, hOption, 
	  -- *** Elementos especiales \"en linea\"
		hA, hApplet, hBaseFont, hBdo, hBr, hFont, hIFrame, hImg, hMap, hArea, hObject, hParam, hQ,
		hSpan, hSub, hSup,			
  	  -- *** Elementos de frase
	  	hAbbr, hAcronym, hCite,	hCode, hDel, hDfn, hEm, hIns, hKbd, hSamp, hStrong, hVar, 
	  -- *** Elementos de estilo de fuente
	  	hB, hBig, hI, hS, hSmall, hStrike, hTt,	hU, 
	  -- *** Frames
	  	hFrame,	hNoFrames,
	
  -- * Creación de atributos HTML 4.0 y CSS2.
  -- | Este módulo define la totalidad de los atributos, propiedades y valores de HTML 4.0 y CSS2.
  -- Para más información visitar <http://www.htmlhelp.com>
  -- y 
  -- <http://www.w3.org/TR/REC-CSS2/cover.html>.
  -- Si alguno de los enlaces no funcionara, entonces buscar la información a partir de <http://www.w3.org>
	module AP.Cgi.Lib.Attributes,

  -- * Primitivas de bloqueo de ficheros.
  {-|   (c) /Pepe Gallardo (pepeg\@lcc.uma.es), 2003/

        Primitivas en C.
  -}
  	module AP.Cgi.Lib.Lock
)where

-- Importación de módulos
import System
import Directory
import IO
import List
import Char
import Random
import Maybe

import AP.Cgi.Lib.Html
import AP.Cgi.Lib.Attributes
import AP.Cgi.Lib.Codification
import AP.Cgi.Lib.Var
import AP.Cgi.Lib.Lock
import AP.Cgi.Lib.M
import AP.Cgi.Lib.Initial
------------------------------------------------------
-- Algunas definiciones útiles
vacio :: FormInfo
vacio = FI {dataEntry     = [],
	    stateType     = InClient,
	    totalValues   = ([],[]),
	    currentValues = ([],[]),
	    totalAsk      = 0,
	    currentAsk    = 0,
	    idCount       = (0,0)
	   }
------------------------------------------------------
-- | runCgiExt es una versión extendida de la función 'runCgi'. Nos permite especificar un nombre de archivo en el caso de 
--  que queramos guardar el resultado (la página generada) en el servidor.
--  También podemos especificar en el segundo argumento booleano si queremos que lea de entrada estándar o 'queryString' si
--  es True, o no leer, si es False.
runCgiExt :: Maybe String -- ^ Nos permite especificar un nombre de archivo si queremos guardar el resultado.
	  -> Bool 	  -- ^ Indica si queremos leer de entrada estándar o queryString 
	  -> StateType	  -- ^ Este argumento indica la forma de guardar el estado de la mónada ('InClient' ó 'InServer').
	  -> Cgi () 	  -- ^ Representa el cómputo (la página) que queremos mostrar.
	  -> IO  ()

runCgiExt file lee st cgi = 
			do {pag <- startCGI_ st cgi' lee
			   ;if (isNothing file) then
			      putStr $ show pag
			    else
			      writeFile (fromJust file) (show pag)
			}
  where 
   Cgi_ cgi' = do { cgi 
                  ; tell $ errorPage_ "Wrong use of form" "Wrong use of form. Press a button in the form"
                  }		

-- | Esta función toma como argumento un Cgi  y muestra la página asociada. 
-- Para ello se apoya en la función "startCgi" implementada más abajo.
-- (En la documentación presentamos la definición de startCgi que es más completa que ésta)
runCgi :: Cgi () 	-- ^ Representa el cómputo (la página) que queremos mostrar.
	  -> IO  ()

runCgi = runCgiExt Nothing True InClient -- No queremos escribir el resultado en un archivo, y queremos que lea la entrada

resetCgi :: StateType -> Cgi () -> Cgi ()
resetCgi st (Cgi_ cgi) = 
 Cgi_ $ do { (x,_)<- readState
  ; writeState (x,vacio)
    ; cgi
    }

--------------------------------------------------------------------------------------
-- $funcionamiento_startCGI_ 
-- La siguiente función recoge los datos (si los hubiera) de los formularios enviados en ejecuciones anteriores. Éste puede
-- ser recogido a través de la entrada estándar (caso de ser método 'Post') o por la variable de entorno 'queryString' (caso
-- de ser método 'Get').
-- Después ejecuta el Cgi que recibe como parámetro una vez decodificados los valores recogidos (que determinarán el 
-- estado inicial para el Cgi) y devuelve la página asociada al mismo.
-- Si no queremos que lea nada de entrada estándar o de la variable de entorno 'queryString', podemos especificarlo
-- con el último argumento a False. Por lo general, este argumento debería ser True. (False es útil si llamamos a 
-- 'runCgi' desde otra página que ya haya ejecutado 'runCgi' a su vez).
startCGI_  :: StateType -> CGI_ () -> Bool -> IO HTML
startCGI_ st body recoge = 
		do {entrada' <- devuelveDatos recoge
		   ;case entrada' of
		      Right error -> muestraError error	 -- Hubo algún error al leer los datos de la entrada.
		      Left entrada -> 			-- Ok, lo hemos leido sin problemas, vamos a inicializar el estado
		        do {datos <- (entryDecode entrada) -- Leemos la entrada y decodificamos los campos.
			   ;info' <- if (null datos) then 	-- Primera vez que se ejecuta
		   	      do {if (st == InServer) then		-- Comprobamos si están el directorio y archivo temporal
			            do {dirFileTest (init tempFilePath) cgiCont
				       ;password <- generaLista		-- generamos el password
				       ;return $ Left $ vacio {stateType = Extern_ password}	-- Lo incluimos en el estado
				    }
				  else
				    return $ Left $ vacio {stateType = InClient}
			      }
		   	    else	-- No es la primera vez que se ejecuta
			      do {(datos',oculto) <- hiddenSearch st datos
			         ;case st of	
				    InClient ->let	-- el campo oculto contiene el estado, lo leemos y ya está
				      		(tv,ta) = read (snd oculto) :: (([String],[String]),Int)
					      in
       						return $ Left $ vacio {dataEntry = datos', stateType = st, totalValues = tv,
				      				       currentValues = tv,  totalAsk = ta, currentAsk = ta}
				    
				    InServer ->do{let	-- el campo oculto contiene el nombre del fichero que guarda el estado, y el password
					   	    (nombreArchivo,passEntrada) = read $ snd oculto :: (String, String) -- El valor asociado a "formFileState"
						    archivo                     = tempFilePath ++ nombreArchivo 
						 ;estadoLeido <- readFile archivo   -- Leemos el estado
						 ;let
						    (estado',passLeido) = read estadoLeido :: ((([String],[String]),Int), String)
						    (tv,ta)             = estado'       -- ::  (([String],[String]),Int)
						 ;if (passEntrada == passLeido) then -- Todo bien
						    return $ Left $ vacio {dataEntry = datos', stateType = Extern_ passLeido,
						 	            	   totalValues = tv, currentValues = tv,  totalAsk = ta, currentAsk = ta}
						  else 		-- Malo, los passwords no coinciden, debemos mostrar un error
						    return $ Right "Bad state received. Please try again."
					      }
			      } `catch` (\err -> return $ Right $ ioeGetErrorString err)
			   ;case info' of
			     Left info -> getHTML $ hDocType info (_CGItoHtml $ catchCGI_ body)  -- en realidad no haria falta ejecutar hDocType, pero es
		      						-- una forma de inicializar todos los valores del estado
			     Right err -> muestraError err
			   }
		}							
  where
      --devuelveDatos :: Bool -> IO 
      devuelveDatos True  = (queryRead `catch` noquery)
      devuelveDatos False = return (Left "")

      queryRead = do {cont <- getEnv queryString
      		     ;return $ Left cont
		  }	-- Aqui no podemos cazar el error, ya que siempre que utilicen metodo post, saltaria el error al leer
		  	-- de la variable de entorno, y estariamos mostrando una pagina de error continuamente

      noquery = \_ -> do {cont <- hGetContents stdin
			   ;return $ Left cont
			} `catch` (\err -> return $ Right $ ioeGetErrorString err) -- otro tipo de error

-- muestraError muestra una página de error a partir de la cadena de error
muestraError :: String -> IO HTML
muestraError mensaje = getHTML $ hDocType vacio (_CGItoHtml $ cgiToCGI_ $ tell $ errorPage_ "Error de Inicialización" mensaje)
