﻿-- #prune,hide

-- Sergio Jimenez Gonzalez  (ult. modificación: 11/4/2003)
-- Titulación: Ing. Técnico en Informática de Sistemas
-- Proyecto fin de carrera.

-- Modulo auxiliar con funciones útiles para cambios de formatos y codificación/decodificación de caracteres
module AP.Cgi.Lib.Codification(
	code,		-- code       :: String -> String
	urlEncode,	-- urlEncode  :: String -> String
	urlDecode	-- urlDecode  :: String -> String
)where

import Char
import List
import Numeric
import Maybe


-- "code" toma una cadena de caracteres que puede tener elementos que deben ser codificados. La cadena se analiza y se 
-- descompone en palabras (se localizan los espacios en blancos) y se analiza independientemente cada una de las palabras.
-- Si en alguna de las palabras aparece un carácter que debe ser codificado, se reemplaza por la cadena correspondiente. 
-- Si encuentra una secuencia como "&xxx;" entonces no se debe codificar el & inicial, puesto que el usuario ya está 
-- haciendo uso de la notación codificada y hay que dejarla tal y como está. En otro caso, se codifican todos los caracteres
-- que sean necesarios mediante la función code'.
code :: String -> String
code s = {-unwords encoded -} analyseWord (filter (/='\r') s)
  where
{-  separateWords = words s			   -- separamos las palabras (función predefinida de Prelude)
    encoded       = map analyseWord separateWords  -- Analizamos cada una de las palabras para codificar sus caracteres -}
    analyseWord :: String -> String
    analyseWord s' = transform ampList comList s'    -- Le pasamos una lista de índices de '&' y otra de índices de ';'
      where
        ampList = elemIndices '&' s'
	comList = elemIndices ';' s'

    transform :: [Int] -> [Int] -> String -> String
    transform amp com s
      |(null amp || null com) = concat $ map code' s		-- No hay '&' o ';', codificamos la cadena entera
      | otherwise = if (ampHead < comHead) then			-- Hay un '&' antes del primer ';'
      		      if ((length amp > 1) && (amp !! 1 < comHead)) then  -- Hay otro '&' antes del primer ';'  
      		        let
		          (xs,ys) = splitAt (amp !! 1) s 		-- Separamos justo antes del segundo '&'
		        in
		          (concat $ map code' xs) ++ 
			  transform (map (sub (amp !! 1)) (tail amp)) (map (sub (amp !! 1)) com) ys
			-- Codificamos la cadena hasta el segundo '&' y actualizamos los indices de las listas de '&' y ';'
		      else
		        let
			  (xs,ys)   = splitAt (comHead+1) s  -- Separamos la cadena que contiene al "&---;" del resto
			  (xs',xs'')= splitAt ampHead xs     -- Del principio separamos los primeros caracteres hasta el '&'
			in
			  (concat $ map code' xs')++xs''++   -- Codificamos la cadena hasta el '&',añadimos "&---;"
			  transform (map (sub (comHead+1)) (tail amp)) (map (sub (comHead+1)) (tail com)) ys 
			  -- y analizamos el resto
		    else
		      let
		        (xs,ys) = splitAt (comHead+1) s
		      in
		       (concat $ map code' xs) ++ transform (map (sub (comHead+1)) amp) (map (sub (comHead+1)) (tail com)) ys
	  where
	    ampHead = head amp
	    comHead = head com
	    sub     = flip (-)

-- "code'" analiza cada caracter y lo convierte en una cadena, si lo encuentra en la lista
code' :: Char -> String
code' c = if (isNothing x) then [c] else (fromJust x)
  where
    x = busca c

-- "busca" localiza en la lista de pares un carácter y devuelve la cadena asociada (si la encuentra)
busca :: Char -> Maybe String
busca c = lookup c listaPares   -- Comparamos solo el primer componente de la tupla

listaPares :: [(Char,String)]
listaPares = [

  ('¨',"&cml;"), 	-- Dieresis  (tambien se puede poner como " &cml; ")
  ('´',"&acute;"),	-- Tilde     (tambien se puede poner como " &acute; ")
  ('"',"&quot;"),	-- comillas
  ('&',"&amp;"),	-- ampersand  
  ('<',"&lt;"),		-- menor que
  ('>',"&gt;"),		-- mayor que
  ('^',"&circ;"),	-- circunflejo
--  ('{',"&lsaquo;"),	-- abre llaves {
--  ('}',"&rsaquo;"),	-- cierra llaves }
  
  ('Ç',"&Ccedil;"),	-- C cedilla mayúscula
  ('ç',"&ccedil;"),	-- C cedilla minúscula
  ('Ñ',"&Ntilde;"),	-- Ñ mayúscula
  ('ñ',"&ntilde;"),	-- ñ minúscula
  
  ('À',"&Agrave;"),	-- A mayúscula con tilde invertida
  ('Á',"&Aacute;"),	-- A mayúscula con tilde
  ('Â',"&Acirc;"),	-- A mayúscula con circunflejo
  ('Ä',"&Auml;"),	-- A mayúscula con diéresis
  
  ('È',"&Egrave;"),	-- E mayúscula con tilde invertida
  ('É',"&Eacute;"),	-- E mayúscula con tilde
  ('Ê',"&Ecirc;"),	-- E mayúscula con circunflejo
  ('Ë',"&Euml;"),	-- E mayúscula con diéresis
  
  ('Ì',"&Igrave;"),	-- I mayúscula con tilde invertida
  ('Ì',"&Iacute;"),	-- I mayúscula con tilde
  ('Î',"&Icirc;"),	-- I mayúscula con circunflejo
  ('Ï',"&Iuml;"),	-- I mayúscula con diéresis
  
  ('Ò',"&Ograve;"),	-- O mayúscula con tilde invertida
  ('Ó',"&Oacute;"),	-- O mayúscula con tilde
  ('Ô',"&Ocirc;"),	-- O mayúscula con circunflejo
  ('Ö',"&Ouml;"),	-- O mayúscula con diéresis
  
  ('Ù',"&Ugrave;"),	-- U mayúscula con tilde invertida
  ('Ú',"&Uacute;"),	-- U mayúscula con tilde
  ('Û',"&Ucirc;"),	-- U mayúscula con circunflejo
  ('Ü',"&Uuml;"),	-- U mayúscula con diéresis
  
  ('Ý',"&Yacute;"),	-- Y mayúscula con tilde
  
  ('à',"&agrave;"),	-- A minúscula con tilde invertida
  ('á',"&aacute;"),	-- A minúscula con tilde
  ('â',"&acirc;"),	-- A minúscula con circunflejo
  ('ä',"&auml;"),	-- A minúscula con diéresis
  
  ('è',"&egrave;"),	-- E minúscula con tilde invertida
  ('é',"&eacute;"),	-- E minúscula con tilde
  ('ê',"&ecirc;"),	-- E minúscula con circunflejo
  ('ë',"&euml;"),	-- E minúscula con diéresis
  
  ('ì',"&igrave;"),	-- I minúscula con tilde invertida
  ('í',"&iacute;"),	-- I minúscula con tilde
  ('î',"&icirc;"),	-- I minúscula con circunflejo
  ('ï',"&iuml;"),	-- I minúscula con diéresis
  
  ('ò',"&ograve;"),	-- O minúscula con tilde invertida
  ('ó',"&oacute;"),	-- O minúscula con tilde
  ('ô',"&ocirc;"),	-- O minúscula con circunflejo
  ('ö',"&ouml;"),	-- O minúscula con diéresis
  
  ('ù',"&ugrave;"),	-- U minúscula con tilde invertida
  ('ú',"&uacute;"),	-- U minúscula con tilde
  ('û',"&ucirc;"),	-- U minúscula con circunflejo
  ('ü',"&uuml;"),	-- U minúscula con diéresis
  
  
  ('ý',"&yacute;")	-- Y minúscula con tilde
   ]


-- urlEncode toma una cadena de caracteres y la codifica según lo especificado en el RFC 1738 de Diciembre del 94 para URL's
-- Deben ser codificados todos los caracteres no pertenecientes al ASCII (rango 80-ff en hexadecimal), los caracteres de 
-- control (rango 00-1f y el 7f), algunos caracteres "inseguros" ( ,<,>,#,%,{,},|,\,^,~,[,],`) y caracteres reservados 
-- tales como  ;,/,?,:,@,=,&
-- En definitiva, los caracteres permitidos son los alfanuméricos y $,-,_,.,+,!,*,',(,)
urlEncode :: String -> String
urlEncode s = concat $ map check s
  where
    check :: Char -> String
    check c
      | (n > 126) || (n < 31) = "%" ++ showHex n ""
      | isJust valor = "%" ++ showHex (ord $ codificables !! indice) ""
      | otherwise = [c]
      where
        n = ord c
	valor  = elemIndex c codificables
	indice = fromJust valor

codificables :: [Char]
codificables = [' ','<','>','#','%','{','}','|','\\','^','~','[',']','`']
-- Los valores resservados ';','/','?',':','@','=','&' no deben ser usados como identificadores ya que forman parte de la 
-- sintaxis reconocida por los navegadores

-- urlDecode realiza la función inversa: toma una cadena de caracteres codificada (se supone que pertenece a un url que
-- hemos recibido de un formulario o algo así) y devuelve la cadena con los caracteres originales

-- ¡¡¡¡¡¡¡¡¡¡¡¡¡¡¡¡   ATENCION  !!!!!!!!!!!!!!!!!! Esta función NUNCA debe utilizarse ANTES de analizar la entrada y 
-- descomponer los argumentos (los formularios usan la notación ?arg1=valor1&arg2=valor2&...) ya que de hacerlo obtendríamos
-- una cadena de caracteres donde algunos de los identificadores (bien nombres de campos o valores introducidos) podrían 
-- tener estos caracteres y nos sería imposible determinar los argumentos originales.
-- Esta función DEBE ser utilizada para decodificar cada uno de los argumentos de dicho URL una vez descompuestos.

urlDecode :: String -> String
urlDecode [] = []
urlDecode ('%':x:x':xs) = caracter : urlDecode xs
  where
    caracter = chr $ fst $ head $ readHex [x,x']
urlDecode (x:xs)
  |x == '+'  = ' ' : urlDecode xs
  |otherwise = x : urlDecode xs
