-- #prune,hide

-- Sergio Jimenez Gonzalez  (ult. modificacin: 5/10/2002)
-- Titulacin: Ing. Tcnico en Informtica de Sistemas

-- Proyecto fin de carrera.

-- Implementacin del tipo Doc 
-- Consiste en un tipo y una clase, a travs de la cual se pueden formatear textos.
module AP.Cgi.Lib.Doc(
	Pretty(pp,	-- pp     :: a -> Doc
	       ppShow), -- ppShow :: a -> String
	Tabulado,
	Doc,
	vacio, 		-- vacio :: Doc
	texto, 		-- texto :: String -> Doc
	(<>),		-- (<>)	:: Doc -> Doc -> Doc
	nl,		-- nl :: Doc
	tab		-- tab :: Tabulado -> Doc -> Doc
) where

-- Definimos una clase para los tipos formateables (pretty print)
class Show a => Pretty a where
  pp     :: a -> Doc
  ppShow :: a -> String

  pp     = texto. show
  ppShow = docAString. pp

instance Pretty Doc where pp = id

-- Tipo Doc
type Tabulado = Integer
data Doc = Vacio		-- Documento vacio
	 | Doc :<> Doc		-- Concatenacin de dos documentos
	 | Nl			-- Salto de linea
	 | Texto String		-- Texto
	 | Tab Tabulado Doc	-- Texto tabulado en "Tabulado" posiciones

-- Funciones bsicas
vacio :: Doc
vacio = Vacio

texto :: String -> Doc
texto s = Texto s

infixl 8 <>, :<>
(<>)	:: Doc -> Doc -> Doc
d1 <> d2 = d1 :<> d2

nl :: Doc
nl = Nl

tab :: Tabulado -> Doc -> Doc
tab i d = Tab i d

-- Funcin que convierte un documento formateable en una cadena de caracteres
docAString  :: Doc -> String
docAString d = docOpt 0 d ""

-- Implementacin de la funcin que pasa a Cadena de forma ptima (con concatenaciones a la derecha)
docOpt 			:: Tabulado -> Doc -> String -> String
docOpt i Vacio 	     s 	= s
docOpt i (d1 :<> d2) s	= docOpt i d1 (docOpt i d2 s)
docOpt i Nl	     s	= "\n" ++ (espacios i ++ s)
docOpt i (Texto str) s	= str ++ s
docOpt i (Tab j d)   s 	= docOpt (i+j) d s

espacios :: Integer -> String
espacios n = replicate (fromInteger n) ' '

-- Instancia a la clase Show para que pueda ser representado en pantalla
instance Show Doc where
  show = docAString

