﻿-- #prune,hide

-- Sergio Jimenez Gonzalez  (ult. modificación: 7/6/2003)
-- Titulación: Ing. Técnico en Informática de Sistemas
-- Proyecto fin de carrera.


-- Modulo para la gestión de los datos de entrada y obtención de los nombres y valores
-- de los campos
module AP.Cgi.Lib.Initial (
	entryDecode,
	hiddenSearch,
	dirFileTest,
	generaLista,
)where

-- Importación de otros módulos
import Directory
import Random

import AP.Cgi.Lib.Html
import List
import AP.Cgi.Lib.Codification


-- Funciones de lectura e interpretación de la información recibida

-- entryDecode toma una cadena de caracteres y determina si se ha recibido información acerca de algún fichero o no.
-- En caso de que así sea, lee los campos de forma conveniente y almacena el contenido del fichero en el servidor?
entryDecode :: String -> IO [(String,String)]
entryDecode []= return []
entryDecode s = do {let
		      matches = separate (=='&') s
		      values  = map getValues matches
		    in 
		      return $ map (\(x,y) -> (urlDecode x,urlDecode y)) values
		}
  where

     -- esta función recoge los valores de los campos si no se ha recibido ningún fichero (tienen formatos diferentes si 
     -- el envío de información ha sido multipart/form-data.
      getValues :: String -> (String,String)
      getValues s = (init xs,ys)
        where
          valor = elemIndex '=' s
	  index = maybe undefined id valor
	  (xs,ys) = splitAt (index+1) s


    -- "hiddenSearch" busca el campo oculto dentro de la información recibida. Si no lo encuentra
    -- provoca un error (hay información superflua que no sabemos interpretar)
    -- si lo encuentra devuelve la lista original recibida menos ese elemento, y ese elemento lo pone a parte.
    -- El primer argumento le indica si estamos utilizando un archivo en el servidor para guardar el estado, o éste
    -- es enviado por completo en el campo oculto. Si es el primer caso, debemos añadir un campo con el estado leido
    -- del archivo. (el nombre del archivo lo recibimos en el campo FORM_FILE_STATE).
hiddenSearch :: StateType -> [(String,String)] -> IO ( [(String,String)], (String,String) )
hiddenSearch st lista = do {final <- oculto
  			   ;if (null final) then -- "ERROR: La información no ha sido recibida correctamente"
			      ioError $ userError ("Información incorrecta en recogida de datos: Falta el campo " ++ 
			    		formState ++ " o el campo " ++ formFileState ++ ".") 
			    else
			     let
			      (f:fs) = final
			     in
			       if (null fs) then		-- Solo hay un elemento
		                 return (lista',f)
			       else			-- Hay más de un elemento en la segunda lista
			         return (lista'++fs,f)    
			}
        where
          separa = case st of
	  	     InClient -> locate formState lista		-- localizamos el estado
		     InServer -> locate formFileState lista	-- Localizamos el nombre del fichero donde esta el estado
	  lista' = fst separa
	  oculto = return $ snd separa
      
dirFileTest :: String -> String -> IO ()
dirFileTest dir file = do {creado <- doesDirectoryExist dir
      			  ;if creado then  	-- ya está creado, comprobamos si está también el archivo
			     do {archivo <- doesFileExist (dir++"\\"++file)
			        ;if archivo then 	-- También está creado, no hacemos nada
			           return ()
			         else		-- El archivo no está creado, lo creamos
		  	           writeFile (dir++"\\"++file) "0"
			     }
			   else			-- No está creado el directorio
			     do {createDirectory dir	-- creamos el directorio
			        ;writeFile (dir++"\\"++file) "0"		-- y creamos el archivo con la cuenta a 0.
			     }
      			}

-- Toma una cadena de caracteres y una función. El resultado es una lista de palabras de dicha cadena, separadas según
-- se satisfaga la función (esta implementación está copiada de words, pero nos permite utilizar cualquier función para
-- determinar cómo separar las palabras)
separate :: Eq a => (a -> Bool) -> [a] -> [[a]]
separate f s = case dropWhile f s of
		 [] -> []
		 s' -> w : separate f s''
		       where
		         (w,s'') = break f s'

----------------------------------------------------------------------------------------------
-- Generación de passwords aleatorios
---------------------------------------------------------------------------------------------
-- Lista de caracteres reservados que no han de codificarse (y no deberían utilizarse)
reservados = ['&','/',':',';','=','?','@'] ++ ['\\','\"','\''] -- algunos problemáticos para haskell

-- Lista de caracteres válidos para generar passwords aleatorias
-- y guardarlas en los ficheros temporales cuando se utilice modo "Extern"
validos :: [Char]
validos = urlEncode lista
  where
    lista = ['\0'..'\255'] \\ reservados

--------------------------------------------------------------
-- Longitud del password (como minimo)
maxChar :: Int
maxChar = 50

-- Limite inferior
minV :: Int
minV = 0

-- Limite superior
maxV :: Int
maxV = 255 - (length reservados)

-- Limite superior para numero aleatorio. Se añadirán como mucho, "maxVAdd" caracteres mas a los ya "maxChar" utilizados.
maxVAdd :: Int
maxVAdd = 15


-- El argumento indica numero de caracteres mas que se deben coger además de los "maxChar". 
-- (para hacer variable la longitud de la cadena)
lista :: Int -> IO [Int]
lista add = sequence [ randomRIO (minV,maxV) | i <- [1 .. maxChar+add] ]

generaLista :: IO [Char]
generaLista = do { variable <- randomRIO (minV,maxVAdd)
		 ; enteros <- lista variable -- generamos una lista de numeros enteros aleatorios
		 ; return $ map (\x -> validos !! x) enteros -- A cada número le hacemos corresponder un caracter de la lista
	      }
