-- #hide
{-|  (c) /Pepe Gallardo (pepeg\@lcc.uma.es), 2003/

     Primitivas en C.

-}

module Lock ( HANDLE
            , lockFile
            , unlockFile
                 
            , exclusiveReadFile
            , exclusiveWriteFile
            , exclusiveAppendFile
                 
            , sleep
            ) where

import Char
import Foreign.Marshal.Array
import Foreign.C.Types
import Foreign.Ptr ( Ptr 
                   , nullPtr
                   )
import Foreign.C.String ( CString
                        , withCString
                        )

type HANDLE = Ptr () 

foreign import ccall unsafe "primwin32Aux.h _lockFile"    _lockFile     :: CString -> IO HANDLE
foreign import ccall unsafe "primwin32Aux.h _unlockFile"  _unlockFile   :: HANDLE -> IO Bool
foreign import ccall unsafe "primwin32Aux.h _getErrorMsg" _getLastError :: IO CString

-- He tenido que redefinir la funcin castCCharToChar en el mdulo CString
-- para que trabaje bien con caracteres acentuados
peekCString    :: CString -> IO String
peekCString cp  = do cs <- peekArray0 endChar cp; return (cCharsToChars cs)
 where
  endChar :: CChar
  endChar = 13

  cCharsToChars :: [CChar] -> [Char]
  cCharsToChars  = map castCCharToChar

  castCCharToChar :: CChar -> Char
  castCCharToChar ch 
   | ch < 0    = chr (256 - fromIntegral (abs ch))
   | otherwise = chr (fromIntegral ch)



getLastError :: IO String
getLastError = 
 do { cString <- _getLastError
    ; str <- peekCString cString
    ; return str
    }


lockFile :: String -> IO HANDLE
lockFile path = 
 do { h <- withCString path _lockFile
    ; if h == nullPtr then do { str <- getLastError
                              ; ioError $ userError str
                              }
                      else return h
    }                  


unlockFile :: HANDLE -> IO ()
unlockFile h =
 do { b <- _unlockFile h
    ; if not b then do { str <- getLastError
                       ; ioError $ userError str
                       }
               else return ()
    }           
    


foreign import ccall unsafe "windows.h Sleep" sleep :: Int -> IO ()

doLocked :: FilePath -> IO a -> IO a
doLocked path io = 
 do { h <- lockFile path
    ; x <- io
    ; unlockFile h
    ; return x
    }
    

exclusiveReadFile :: FilePath -> IO String
exclusiveReadFile path = doLocked path $ readFile path

exclusiveWriteFile :: FilePath -> String -> IO ()
exclusiveWriteFile path str = doLocked path $ writeFile path str

exclusiveAppendFile :: FilePath -> String -> IO ()
exclusiveAppendFile path str = doLocked path $ appendFile path str


 
 
 
 
