-- #prune,hide

-- Sergio Jimenez Gonzalez  (ult. modificacin 11/4/2003)
-- Titulacin: Ing. Tcnico en Informtica de Sistemas

-- Implementacin de un tranformador de estados con encapsulamiento de acciones IO y control de excepciones
module AP.Cgi.Lib.M (
   -- Tipos bsicos
	M,
	Status,
  -- Funciones de apoyo
	isReturn,	-- isReturn :: Status s e a -> Bool
	getState,	-- getState :: Status s e a -> s
	getError,	-- getError :: Status s e a -> e
  -- Funciones para el funcionamiento y manipulacin de la mnada
	readState,	-- readState  :: M s e s
	writeState,	-- writeState :: s -> M s e ()
	runM,		-- runM   :: M s e a -> s -> IO (Status s e a)
  -- Funciones para el trato de E/S y manejo de excepciones
	ioM,		-- ioM    :: IO a -> M s e a
	raiseM, 	-- raiseM :: e -> M s e a
	catchM		-- catchM :: M s e a -> (e -> M s e a) -> M s e a
) where
  
-- Utilizamos el siguiente tipo para representar un estado correcto  una excepcin.
data Status s e a = Raise e
		  | Return (a,s)

-- donde 's' es el tipo del estado de la computacin, 'e' es el tipo devuelto en las excepciones y 'a' es el tipo del
-- valor devuelto por el cmputo.

-------------------------------------------------------------
-- Algunas funciones tiles para saber algo sobre el estado
isReturn :: Status s e a -> Bool
isReturn (Return _) = True
isReturn _          = False

getState :: Status s e a -> s
getState (Return (a,s)) = s
getState _              = error "getState: Not Return value"

getError :: Status s e a -> e
getError (Raise p) = p
getError _         = error "getError: Not Raise value"
-------------------------------------------------------------

data M s e a = M (s -> IO (Status s e a))

--  "M s e a" representa un cmputo que devuelve un dato de tipo 'a', puede elevar una excepcion de tipo 'e'
-- y puede consultar y modificar un estado de tipo 's'. Todo esto encapsulado dentro de la mnada "IO".
  
-- Hacemos instancia de la clase "Functor"
instance Functor (M s e) where
  -- fmap :: (a -> b) -> M s e a -> M s e b
  fmap f (M g) = M (\s -> do {state <- g s
  			     ;case state of
			        (Raise e)       -> return (Raise e)
				(Return (a,s')) -> let
						     a'     = f a
						     state' = Return (a',s')
						   in
						     return state'
			  }
		   )

-- Hacemos instancia de la clase "Monad"
instance Monad (M s e) where
  -- return :: a -> M s e a
  return x = M (\s -> return (Return (x,s)))

  -- (>>=) :: M s e a -> (a -> M s e b) -> M s e b
  (M g) >>= f = M (\s -> do {state <- g s
  			    ;case state of
			       (Raise e)     -> return (Raise e)
			       (Return (a,s')) -> let
			       			    M g' = f a
						  in
						    g' s'
			 }
		  )

------------------------------------------------
-- Algunas funciones tiles

-- Funcin que lee el estado
readState :: M s e s
readState = M (\s -> return (Return (s, s)))

-- Funcin que reemplaza el estado
writeState :: s -> M s e ()
writeState s' = M (\s -> return (Return ((),s')))

-- Funcin que devuelve el valor del cmputo, a partir de un estado inicial, ignorando el estado final
runM :: M s e a -> s -> IO (Status s e a)
runM (M f) s = f s

-------------------------------------------------
-- Funciones para manejo de excepciones y acciones IO

-- Esta funcin toma una accin IO y devuelve la mnada correspondiente a dicha accin manteniendo el estado original
ioM :: IO a -> M s e a
ioM f = M (\s -> do {val <- f
		    ;return (Return (val,s))
		    }
	  )

-- Esta funcin eleva una excepcin con el valor que toma como argumento
raiseM :: e -> M s e a
raiseM p = M (\s -> return (Raise p))

-- catchM toma una mnada y una funcin. Si el primero es una excepcion (un Raise) ignora el resultado 
-- y devuelve la segunda mnada con el estado resultante de aplicar la funcin (segundo parmetro) al estado recogido
-- de la excepcin (primer argumento). Si la primera mnada no es una excepcin, se devuelve tal cual.
catchM :: M s e a -> (e -> M s e a) -> M s e a
catchM (M f) g = M (\s -> do {val <- f s
			     ;case val of
				(Return (a,s')) -> return (Return (a,s'))
				(Raise p)       -> let
						     (M g') = g p
						   in
						     g' s
			     }
		   )
