-- #prune,hide

-- Sergio Jimenez Gonzalez  (ult. modificacin: 11/4/2003)
-- Titulacin: Ing. Tcnico en Informtica de Sistemas
-- Proyecto fin de carrera.

module AP.Cgi.Lib.Var (
  -- Variables tiles
	serverSoftware, serverVersion, serverName, serverUrl, serverPort,
	serverProtocol, gatewayInterface, requestMethod, queryMethod,
	contentType, contentLength, remoteUser, remoteHost, remoteAddr,
	scriptPath, scriptName, queryString, pathInfo, pathTranslated,
	cgiRoot, cgiStdIn, cgiStdOut, cgiStdErr, documentRoot	
) where

-------------------
serverSoftware   :: String
-- ^ Nombre del servidor.
serverSoftware   = "SERVER_SOFTWARE"	

serverVersion   :: String
-- ^ Versin del servidor web.
serverVersion    = "SERVER_VERSION"	

serverName       :: String
-- ^ Nombre de servidor actual (host).
serverName       = "SERVER_NAME"	

serverUrl        :: String
-- ^ El Url completo para el servidor.
serverUrl        = "SERVER_URL"		

serverPort       :: String
-- ^ Puerto donde se est ejecutando el servidor.
serverPort       = "SERVER_PORT"	

serverProtocol   :: String
-- ^ Versin HTTP (ej. \"HTTP\/1.0\"). 
serverProtocol   = "SERVER_PROTOCOL"	

gatewayInterface :: String
-- ^ Versin Cgi  (ej. \"Cgi\/1.1\"). 
gatewayInterface = "GATEWAY_INTERFACE"	

requestMethod    :: String
-- ^ Mtodo HTTP usado, 'AP.Cgi.Lib.Html.Get' o 'AP.Cgi.Lib.Html.Post'. 
requestMethod    = "REQUEST_METHOD"	

queryMethod      :: String
-- ^ Igual que 'requestMethod', mtodo HTTP usado, 'AP.Cgi.Lib.Html.Get' o 'AP.Cgi.Lib.Html.Post'.
queryMethod      = "QUERY_METHOD"

contentType      :: String
-- ^ Tipo de contenido.
contentType      = "CONTENT_TYPE"

contentLength    :: String
-- ^ Longitud (nmero de caracteres) recibidos.
contentLength    = "CONTENT_LENGTH"	

remoteUser       :: String
-- ^ Usuario autorizado, si lo hay, en otro caso \"-\"; solo se utilizar al entrar en URL's protegidos. 
remoteUser       = "REMOTE_USER"	

remoteHost       :: String
-- ^ Igual que 'remoteAddr', direccin del host remoto, \"x.x.x.x\".
remoteHost       = "REMOTE_HOST"

remoteAddr       :: String
-- ^ Direccin del host remoto, \"x.x.x.x\".
remoteAddr       = "REMOTE_ADDR"	

scriptPath       :: String
-- ^ Path del script que se est ejecutando.
scriptPath       = "SCRIPT_PATH"	

scriptName       :: String
-- ^ URI del script que se est ejecutando.
scriptName       = "SCRIPT_NAME"	

queryString      :: String
-- ^ Es la cadena que sigue al URL (los parmetros recibidos del formulario).
queryString      = "QUERY_STRING"	

pathInfo         :: String
-- ^ Es cualquier informacin de path siguiendo al URL de cgi.
pathInfo         = "PATH_INFO"		

pathTranslated   :: String
-- ^ Path completo traducido con argumentos URL.
pathTranslated   = "PATH_TRANSLATED"	

cgiRoot		 :: String
-- ^ Directorio binario de cgi.
cgiRoot		 = "Cgi_ROOT"		

cgiStdIn         :: String
-- ^ Fichero de entrada estndar Cgi.
cgiStdIn         = "Cgi_STDIN"		

cgiStdOut	 :: String
-- ^ Fichero de salida estndar Cgi.
cgiStdOut	 = "Cgi_STDOUT"		

cgiStdErr	 :: String
-- ^ Fichero de error estndar Cgi, si lo hubiera.
cgiStdErr	 = "Cgi_STDERR"		

documentRoot     :: String
-- ^ Directorio raiz de las pginas de inicio.
documentRoot     = "DOCUMENT_ROOT"	
-----------------------------------------------------------------------------------------
