//-------------------------------------------------------------------------
#include <iostream>
#include <string>
#include <cctype>
#include <ctime>
#include <cassert>
#include <array>

#define NAFLUSH__
#include <ext/ioconsole.hpp>
using namespace std;

//-------------------------------------------------------------------------
const unsigned LOOP_TIME = 25; // milisegundos
//-------------------------------------------------------------------------
// La primera fila de la imagen no puede ser vacia
const unsigned MAX_FILAS = 5;
typedef array<string, MAX_FILAS> Imagen;
const unsigned UMBRAL_ESTRELLA = 3;
const Imagen ESTRELLA = {{
	" \\|/ ",
	"--o--",
	" /|\\ "
}};
// const Imagen NAVE = {{
// 	"<<[o]>>"
// }};
// const Imagen NAVE = {{
// 	" /\\",
// 	"/__\\"
// }};
// const Imagen NAVE = {{
// 	" _/\\_",
// 	"/____\\"
// }};
// const Imagen NAVE = {{
// 	" _/\\_",
// 	"/_\\/_\\"
// }};
// const Imagen NAVE = {{
// 	" _/\\_",
// 	"/_||_\\"
// }};
// const Imagen NAVE = {{
// 	" _/\\_",
// 	"/_[]_\\"
// }};
const unsigned UMBRAL_NAVE = 1;
const Imagen NAVE = {{
	" _/\\_",
	"/_[]_\\",
	"\\/  \\/"
}};
const unsigned UMBRAL_PROYECTIL = 1;
const Imagen PROYECTIL = {{
	"::"
}};
enum Objetos {
	estrella, nave, proyectil
};
//-------------------------------------------------------------------------
//-- Aleatorio ------------------------------------------------------------
//-------------------------------------------------------------------------
// Inicializa el generador de numeros aleatorios
// void ini_aleatorio(int x = 0)
// {
//     srand(time(0)+x);
// }
// Devuelve un numero aleatorio entre 0 y max (exclusive)
// int aleatorio(int max)
// {
//     return int(double(rand())*max/(RAND_MAX+1.0));
// }
// devuelve un numero entre [inf..sup] ambos inclusive
// int aleatorio_rango(int inf, int sup)
// {
//     return inf + aleatorio(sup - inf + 1);
// }
//-------------------------------------------------------------------------
//-- Video ----------------------------------------------------------------
//-------------------------------------------------------------------------
struct Video {
    unsigned min_col;
    unsigned max_col;
    unsigned min_fil;
    unsigned max_fil;
};
//------------------------------------
void inicializar_video(Video& v)
{
	clock_t t1 = clock();
    cout << "Redimensione la pantalla y pulse [ENTER]" << endl;
	cio >> disable_buffer;
    cio.getkey();
	t1 = clock()-t1;
	ini_aleatorio(t1);
    text_info inf;
    cio >> inf;
    if ((inf.screenheight < 20)||(inf.screenwidth < 50)) {
        cout << "Pantalla demasiado pequena ["
			 << inf.screenheight << ", "
			 << inf.screenwidth<< "]"<< endl;
		pausa();
        exit(EXIT_FAILURE);
    }
    cio << no_cursor << clear_screen;
    v.min_col = inf.winleft+1;
    v.max_col = inf.winright-1;
    v.min_fil = inf.wintop+1;
    v.max_fil = inf.winbottom-1;
}
//------------------------------------
void bordes_video(const Video& v)
{
	for (unsigned i = v.min_fil; i <= v.max_fil; ++i) {
		cio << cursorxy(v.min_col, i) << '|';
	}
	for (unsigned i = v.min_fil; i <= v.max_fil; ++i) {
		cio << cursorxy(v.max_col, i) << '|';
	}
	for (unsigned i = v.min_col; i <= v.max_col; ++i) {
		cio << cursorxy(i, v.min_fil) << '-';
	}
	for (unsigned i = v.min_col; i <= v.max_col; ++i) {
		cio << cursorxy(i, v.max_fil) << '-';
	}
	cio << cursorxy(v.min_col, v.max_fil+1)
		<< "[Space] [CursorKeys] [Home] [End] [PgUp] [PgDown]";
	cio << flush;
}
//-------------------------------------------------------------------------
//-- Objeto ---------------------------------------------------------------
//-------------------------------------------------------------------------
struct Obj {
	Objetos id;
	unsigned fil;
	unsigned col;
	unsigned alt;
	unsigned anch;
	unsigned color;
	unsigned activo;
	unsigned umbral;
	Imagen img;
};
//------------------------------------
const unsigned DEF_COLOR = -1U;
const unsigned DEF_ACTIVO = 3;
//------------------------------------
void dimension_obj(Obj& obj)
{
	assert(obj.img[0].size() > 0);
	unsigned anc = 0;
	unsigned alt = 0;
	for (unsigned i = 0; i < obj.img.size(); ++i) {
		if (obj.img[i].size() > 0) {
			alt = i;
			if (obj.img[i].size() > anc) {
				anc = obj.img[i].size();
			}
		}
	}
	obj.alt = alt + 1;
	obj.anch = anc;
}
//------------------------------------
void create_obj(Obj& obj, const Imagen &imagen, Objetos idd, unsigned umbral,
				unsigned color = DEF_COLOR,
				unsigned activo = DEF_ACTIVO,
				unsigned f = 0, unsigned c = 0)
{
	assert(umbral > 0);
	obj.id = idd;
	obj.umbral = umbral;
	obj.img = imagen;
	dimension_obj(obj);
	obj.fil = f;
	obj.col = c;
	obj.color = color;
	obj.activo = activo;
}
//------------------------------------
bool visible(const Video& v, const Obj& o)
{
	return ((int(o.fil) > int(v.min_fil))
			&&(int(o.fil+o.alt) <= int(v.max_fil))
			&&(int(o.col) > int(v.min_col))
			&&(int(o.col+o.anch) <= int(v.max_col)));
}
//------------------------------------
void dibujar(const Video& v, const Obj& o)
{
	if (visible(v,o)) {
		if (o.color <= WHITE) {
			cio << color(o.color);
		}
		for (unsigned i = 0; i < o.alt; ++i) {
			for (unsigned j = 0; j < o.img[i].size(); ++j) {
				if (isgraph(o.img[i][j])) {
					cio << cursorxy(o.col+j, o.fil+i) << o.img[i][j];
				}
			}
		}
		if (o.color <= WHITE) {
			cio << normal_video;
		}
		cio<<flush;
	}
}
//------------------------------------
void borrar(const Video& v, const Obj& o)
{
	if (visible(v,o)) {
		for (unsigned i = 0; i < o.alt; ++i) {
			for (unsigned j = 0; j < o.img[i].size(); ++j) {
				if (isgraph(o.img[i][j])) {
					cio << cursorxy(o.col+j, o.fil+i) << ' ';
				}
			}
		}
	}
}
//------------------------------------
bool visible(const Video& v, const Obj& o, int incf, int incc)
{
	return ((int(o.fil)+incf > int(v.min_fil))
			&&(int(o.fil+o.alt)+incf <= int(v.max_fil))
			&&(int(o.col)+incc > int(v.min_col))
			&&(int(o.col+o.anch)+incc <= int(v.max_col)));
}
//------------------------------------
void mover(const Video& v, Obj& obj, int incf, int incc)
{
	if (visible(v, obj, incf, incc)) {
		borrar(v, obj);
		obj.fil += incf;
		obj.col += incc;
		dibujar(v, obj);
	}
}
//------------------------------------
inline bool activo(const Obj& o)
{
	return o.activo > 0;
}
//------------------------------------
//-- Colision ------------------------
//------------------------------------
inline int menor(int x, int y)
{
	return (x < y) ? x : y;
}
//------------------------------------
inline void indices(unsigned o1, unsigned sz1, unsigned o2, unsigned sz2,
					unsigned& i1, unsigned& i2, unsigned& sz)
{
	if (o1 < o2) {
		i2 = 0;
		i1 = o2 - o1;
	} else {
		i1 = 0;
		i2 = o1 - o2;
	}
	int aux = menor(int(sz1)-int(i1), int(sz2)-int(i2));
	sz = unsigned(aux < 0 ? 0 : aux);
}
//------------------------------------
bool colision(const Obj& o1, const Obj& o2)
{
	unsigned f1, f2, fsz;
	unsigned c1, c2, csz;
	indices(o1.fil, o1.alt, o2.fil, o2.alt, f1, f2, fsz);
	indices(o1.col, o1.anch, o2.col, o2.anch, c1, c2, csz);
	bool res = false;
	if ((fsz > 0)&&(csz > 0)) {
		for (unsigned i = 0; (i < fsz)&&!res; ++i) {
			for (unsigned j = 0; (j < csz)&&!res; ++j) {
				res = (c1+j < o1.img[f1+i].size())
					&&(c2+j < o2.img[f2+i].size())
					&&isgraph(o1.img[f1+i][c1+j])
					&&isgraph(o2.img[f2+i][c2+j]);
			}
		}
	}
	return res;
}
//-------------------------------------------------------------------------
//-- Piezas ---------------------------------------------------------------
//-------------------------------------------------------------------------
const unsigned MAX_SEC = 16;
typedef array<string, MAX_SEC> Secuencias;
const Secuencias SECUENCIAS = {{
	"/-\\|",
	"|/-\\",
	"\\-/|",
	"-/|\\",
	"_/|\\",
	"^>v<",
	">v<^",
	"v<^>",
	"<^>v",
	"oO@*+x#",
	"(/-\\",
	")/-\\",
	"[/-\\",
	"]/-\\",
	"#@Oo:x",
	""
}};

struct Pieza {
	unsigned fil;	// posicion del objeto
	unsigned col;	// posicion del objeto
	unsigned lim_col;	// para movimiento automatico de parabola
	unsigned lim_fil;	// para movimiento automatico de parabola
	int inc_col;	// para movimiento automatico de parabola
	int inc_fil;	// para movimiento automatico de parabola
	unsigned color;	// color de la pieza
	unsigned activo;	// tiempo de vida
	unsigned idx;	// indice a la imagen de la secuencia
	string sec;// secuencia de piezas
};

const unsigned MAX_PIEZAS = 100;
typedef array<Pieza, MAX_PIEZAS> APiezas;
struct VPiezas {
	unsigned nelms;
	APiezas elm;
};
//-------------------------------------------------------------------------
unsigned buscar_secuencia(const Secuencias& sec, char img)
{
	unsigned i;
	for (i = 0; ((i < sec.size())
				 &&(sec[i].size() > 0)
				 &&(sec[i][0] != img));
		 ++i) {
		// vacio
	}
	if ( ! ((i < sec.size())&&(sec[i].size() > 0)) ) {
		i = 0;
	}
	return i;
}
bool visible(const Video& v, const Pieza& pz)
{
	return ((int(pz.fil) > int(v.min_fil))
			&&(int(pz.fil+1) <= int(v.max_fil))
			&&(int(pz.col) > int(v.min_col))
			&&(int(pz.col+1) <= int(v.max_col)));
}
void borrar_pieza(const Video& v, const Pieza& pz)
{
	if (visible(v,pz)) {
		cio << cursorxy(pz.col, pz.fil) << ' ';
	}
}
void dibujar_pieza(const Video& v, const Pieza& pz)
{
	if (visible(v,pz)) {
		if (pz.color <= WHITE) {
			cio << color(pz.color);
		}
		cio << cursorxy(pz.col, pz.fil) << pz.sec[pz.idx];
		if (pz.color <= WHITE) {
			cio << normal_video;
		}
		cio<<flush;
	}
}
// Crea los parametros iniciales del movimiento de la pieza
void crear_pieza(Pieza& pz, char img,
				 unsigned color = -1U,
				 unsigned f = 0, unsigned c = 0)
{
	pz.fil = f;
	pz.col = c;
	pz.lim_col = aleatorio(3, 7);
	pz.lim_fil = aleatorio(5, 10);
	pz.activo = aleatorio(20, 25);
	pz.color = color;
	pz.inc_fil = -1;
	if (aleatorio(2) == 0) {
		pz.inc_col = -1;
	} else {
		pz.inc_col = +1;
	}
	pz.idx = 0;
	pz.sec = SECUENCIAS[buscar_secuencia(SECUENCIAS, img)];
}
/*
 *	movimiento automatico de la pieza
 *	OK a FALSE cuando el movimiento termine
 */
void inc_mov(Pieza& pz, bool& ok)
{
	ok = false;
	if (pz.activo > 0) {
		ok = true;
		--pz.activo;
		if (pz.lim_col > 0) {
			--pz.lim_col;
		} else {
			pz.inc_col = 0;
		}
		if (pz.lim_fil > 0) {
			--pz.lim_fil;
		} else {
			pz.inc_fil = +1;
		}
		++pz.idx;
		if (pz.idx == pz.sec.size()) {
			pz.idx = 0;
		}
		pz.col += pz.inc_col;
		pz.fil += pz.inc_fil;
	}
}
/*
 *	movimiento automatico de la pieza
 *	OK a FALSE cuando el movimiento termine
 */
void mover_pieza(const Video& v, Pieza& pz, bool& ok)
{
	borrar_pieza(v, pz);
	inc_mov(pz, ok);
	if (ok) {
		dibujar_pieza(v, pz);
	} else {
		cio<<flush;
	}
}
//------------------------------------
// Inicializa el vector de piezas a vacio
void ini_piezas(VPiezas& vpz)
{
	vpz.nelms = 0;
}
// Anyade una pieza al vector
void anyadir_pieza(VPiezas& vpz, const Pieza& pz)
{
	if (vpz.nelms < vpz.elm.size()) {
		vpz.elm[vpz.nelms] = pz;
		++vpz.nelms;
	}
}
// Elimina una pieza del vector
void eliminar_pieza(VPiezas& vpz, unsigned i)
{
	assert(i < vpz.nelms);
	--vpz.nelms;
	if (i < vpz.nelms) {
		vpz.elm[i] = vpz.elm[vpz.nelms];
	}
}
// crea las piezas para un objeto
void obj_piezas(VPiezas& vpz, const Obj& o)
{
	for (unsigned i = 0; i < o.alt; ++i) {
		for (unsigned j = 0; j < o.img[i].size(); ++j) {
			if ((vpz.nelms < vpz.elm.size())&&isgraph(o.img[i][j])) {
				Pieza pz;
				crear_pieza(pz, o.img[i][j], o.color, o.fil+i, o.col+j);
				anyadir_pieza(vpz, pz);
			}
		}
	}
}
//------------------------------------
void movimiento_piezas(const Video& v, VPiezas& vpz)
{
	bool ok;
	unsigned i = 0;
	while (i < vpz.nelms) {
		mover_pieza(v, vpz.elm[i], ok);
		if (ok) {
			++i;
		} else {
			eliminar_pieza(vpz, i);
		}
	}
}
//------------------------------------
void loop_sleep(int loop_time, int level, clock_t c1, clock_t c2);
//------------------------------------
// crea las piezas del objeto y su movimiento hasta el final
void destruir_objeto(const Video& v, const Obj& o)
{
	VPiezas vpz;
	ini_piezas(vpz);
	obj_piezas(vpz, o);
	while (vpz.nelms > 0) {
		clock_t c1 = clock();
		movimiento_piezas(v, vpz);
		loop_sleep(LOOP_TIME, 1, c1, clock());
	}
}
//-------------------------------------------------------------------------
//-- Objeto con Movimiento Automatico -------------------------------------
//-------------------------------------------------------------------------
struct MObj {
	Obj obj;
	int incf;
	int incc;
};
//------------------------------------
void create_mobj(MObj& obj, const Imagen &imagen, Objetos idd, unsigned umbral,
				 unsigned color = DEF_COLOR,
				 unsigned activo = DEF_ACTIVO,
				 unsigned f = 0, unsigned c = 0,
				 int ifl = 0, int icl = 0)
{
	create_obj(obj.obj, imagen, idd, umbral, color, activo, f, c);
	obj.incf = ifl;
	obj.incc = icl;
}
//------------------------------------
void mover(const Video& v, MObj& obj)
{
	if ((obj.incf != 0)||(obj.incc != 0)) {
		mover(v, obj.obj, obj.incf, obj.incc);
	}
}
//------------------------------------
void limites(const Video& v, MObj& o)
{
	switch (o.obj.id) {
	case estrella:
		if (o.obj.fil <= v.min_fil+1) {
			o.incf = +1;
		}
		if (o.obj.fil+o.obj.alt >= v.max_fil) {
			o.incf = -1;
		}
		if (o.obj.col <= v.min_col+1) {
			o.incc = +1;
		}
		if (o.obj.col+o.obj.anch >= v.max_col) {
			o.incc = -1;
		}
		break;
	case nave:
		break;
	case proyectil:
		if (o.obj.fil <= v.min_fil+1) {
			o.obj.activo = 0;
		} 
		break;
	}
}
//------------------------------------
void movimiento_auto(const Video& v, MObj& o)
{
	mover(v, o);
	limites(v, o);
}
//------------------------------------
void invertir(MObj& o)
{
	o.incf = -o.incf;
	o.incc = -o.incc;
}
//------------------------------------
inline bool colision(const MObj& o1, const MObj& o2)
{
	return colision(o1.obj, o2.obj);
}
inline bool colision(const Obj& o1, const MObj& o2)
{
	return colision(o1, o2.obj);
}
//------------------------------------
void colisiona(const Video& v, VPiezas& vpz,
			   MObj& o1, const MObj& o2)
{
	switch (o1.obj.id) {
	case estrella:
		invertir(o1);
		limites(v, o1);
		if (o2.obj.id == proyectil) {
			--o1.obj.activo;
// 			if (o1.obj.activo == 0) {
// 				destruir_objeto(v, o1.obj);
// 			} else {
// 				obj_piezas(vpz, o1.obj);
// 			}
			obj_piezas(vpz, o1.obj);
		}
		movimiento_auto(v, o1);
		break;
	case nave:
		if (o2.obj.id == estrella) {
			--o1.obj.activo;
// 			if (o1.obj.activo == 0) {
// 				destruir_objeto(v, o1.obj);
// 			} else {
// 				obj_piezas(vpz, o1.obj);
// 			}
			obj_piezas(vpz, o1.obj);
		}
		break;
	case proyectil:
		if (o2.obj.id == estrella) {
			o1.obj.activo = 0;
		}
		break;
	}
}
//-------------------------------------------------------------------------
//-- Multiples Objetos ----------------------------------------------------
//-------------------------------------------------------------------------
const unsigned MAX_OBJETOS = 100;
typedef array<MObj, MAX_OBJETOS> AMObjs;
struct VMObjs {
	unsigned nelms;
	AMObjs elm;
};
void ini_vobjs(VMObjs& vo)
{
	vo.nelms = 0;
}
void anyadir_obj(VMObjs& vo, const MObj& o)
{
	if (vo.nelms < vo.elm.size()) {
		vo.elm[vo.nelms] = o;
		++vo.nelms;
	}
}
void eliminar_obj(VMObjs& vo, unsigned i)
{
	assert(i < vo.nelms);
	--vo.nelms;
	if (i < vo.nelms) {
		vo.elm[i] = vo.elm[vo.nelms];
	}
}
// unsigned purgar_objs(VMObjs& vo)
// {
// 	unsigned cnt = 0;
// 	unsigned i = 0;
// 	while (i < vo.nelms) {
// 		if (activo(vo.elm[i].obj)) {
// 			++i;
// 		} else {
// 			eliminar_obj(vo, i);
// 			++cnt;
// 		}
// 	}
// 	return cnt;
// }
//------------------------------------
void control_teclado(const Video& v, MObj& o, VMObjs& vobjs)
{
	if (o.obj.id == nave) {
		if (cio.kbhit()) {
			MObj proy;
			unsigned k;
			cio >> key(k) ;
			int _if = 0;
			int _ic = 0;
			switch(k) {
			case KEY_UP:    _if = -1; break;
			case KEY_DOWN:  _if = +1; break;
			case KEY_LEFT:  _ic = -1; break;
			case KEY_RIGHT: _ic = +1; break;
			case KEY_CTRL_UP:
			case KEY_PGUP:  _if = 3-int(o.obj.fil); break;
			case KEY_CTRL_DOWN:
			case KEY_PGDOWN:_if = int(v.max_fil)-int(o.obj.fil)-o.obj.alt; break;
			case KEY_CTRL_LEFT:
			case KEY_HOME:  _ic = 3-int(o.obj.col); break;
			case KEY_CTRL_RIGHT:
			case KEY_END:   _ic = int(v.max_col)-int(o.obj.col)-o.obj.anch; break;
			case KEY_DELETE: o.obj.activo = 0; break;
			case ' ':
				create_mobj(proy, PROYECTIL, proyectil, UMBRAL_PROYECTIL,
							MAGENTA, 1,
							o.obj.fil-1, o.obj.col+(o.obj.anch/2)-1, -1, 0);
				anyadir_obj(vobjs, proy);
				break;
			}
			mover(v, o.obj, _if, _ic);
		} else {
			dibujar(v, o.obj);
		}
	}
}
//------------------------------------
void movimiento(const Video& v, MObj& o, VMObjs& vo)
{
	if (o.obj.id == nave) {
		control_teclado(v, o, vo);
	} else {
		movimiento_auto(v, o);
	}
}
//------------------------------------
inline bool tiempo_activo(unsigned tiempo, const Obj& obj) {
	return (tiempo % obj.umbral == 0);
}
//------------------------------------
void movimiento_objs(const Video& v, VMObjs& vo, unsigned tiempo)
{
	unsigned i = 0;
	while (i < vo.nelms) {
		if (activo(vo.elm[i].obj)) {
			if (tiempo_activo(tiempo, vo.elm[i].obj)) {
				movimiento(v, vo.elm[i], vo);
			}
			++i;
		} else {
			borrar(v, vo.elm[i].obj);
			eliminar_obj(vo, i);
		}
	}
}
unsigned check_colisiones_objs(const Obj& obj, const VMObjs& vo, unsigned i = -1U)
{
	unsigned j = vo.nelms;
	if (activo(obj)) {
		for (j = 0; (j < vo.nelms)&&
				 !((i != j)&&(colision(obj, vo.elm[j]))); ++j) {
			//vacio
		}
	}
	return j;
}
void colisiones_objs(const Video& v, VMObjs& vo, VPiezas& vpz)
{
	unsigned i = 0;
	while (i < vo.nelms) {
		unsigned j = check_colisiones_objs(vo.elm[i].obj, vo, i);
		if (j < vo.nelms) {
			colisiona(v, vpz, vo.elm[i], vo.elm[j]);
		}
		++i;
	}
}
inline void mov_col_objs(const Video& v, VMObjs& vo, VPiezas& vpz,
						 unsigned tiempo)
{
	movimiento_objs(v, vo, tiempo);
	colisiones_objs(v, vo, vpz);
}
//-------------------------------------------------------------------------
//-- Juego ----------------------------------------------------------------
//-------------------------------------------------------------------------
void print_cnt(const Video& v, unsigned n)
{
	cio << cursorxy((v.min_col+v.max_col)/2,v.min_fil) << n << flush;
}
//------------------------------------
/*
 *	velocidad de juego (independiente de velocidad de CPU)
 */
void loop_sleep(int loop_time, int level, clock_t c1, clock_t c2)
{
	clock_t sc;
	clock_t cl = c2 - c1;
	// millisecs to clocks
	clock_t loop_clocks = loop_time * CLOCKS_PER_SEC / 1000;
	loop_clocks /= (1.0 + (0.25 * level));
	if (loop_clocks > cl) {
		sc = loop_clocks - cl;
		msleep(sc * 1000 / CLOCKS_PER_SEC);	// clocks to millisecs
	}
}
//------------------------------------
void juego(const Video& v)
{
	VMObjs vobjs;
	ini_vobjs(vobjs);
	VPiezas vpz;
	ini_piezas(vpz);
	//unsigned cnt = 0;
	MObj obj;
	//--------------------------------
	create_mobj(obj, NAVE, nave, UMBRAL_NAVE, GREEN, DEF_ACTIVO,
				v.max_fil-3, (v.max_col+v.min_col)/2-3, 0, 0);
	anyadir_obj(vobjs, obj);
	//--------------------------------
	create_mobj(obj, ESTRELLA, estrella, UMBRAL_ESTRELLA, RED, DEF_ACTIVO,
				v.min_fil+7, v.min_col+11, +1, +1);
	anyadir_obj(vobjs, obj);
	//--------------------------------
	create_mobj(obj, ESTRELLA, estrella, UMBRAL_ESTRELLA, BLUE, DEF_ACTIVO,
				v.max_fil-7, v.max_col-11, -1, -1);
	anyadir_obj(vobjs, obj);
	//--------------------------------
	unsigned tiempo = 0;
	while ((vpz.nelms > 0)||((vobjs.nelms > 1)&&(vobjs.elm[0].obj.id == nave))) {
		clock_t c1 = clock();
		++tiempo;
		if ((vobjs.nelms > 0)&&(vobjs.elm[0].obj.id == nave)) {
			print_cnt(v, vobjs.elm[0].obj.activo);
		}
		mov_col_objs(v, vobjs, vpz, tiempo);
		//if ((vpz.nelms == 0)||(cnt < 2)) {
		//	if (mov_col_objs(v, vobjs, vpz) > 0) {
		//		++cnt;
		//	}
		//}
		movimiento_piezas(v, vpz);
		loop_sleep(LOOP_TIME, 1, c1, clock());
	}
}
//-------------------------------------------------------------------------
int main()
{
	ini_aleatorio();
	Video video;
    inicializar_video(video);
    bordes_video(video);
	juego(video);
    cio << cursorxy(1,video.max_fil)<< endl << clear_line ;
    pausa();
    cout << endl;
    return 0;
}
//-------------------------------------------------------------------------
